% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ipd.meteESF.R
\name{metePsi}
\alias{metePsi}
\title{Equation of the PMF for the METE individual metabolic rate distribution}
\usage{
metePsi(e, la1, la2, Z, S0, N0, E0)
}
\arguments{
\item{e}{the value (metabolic rate/power) at which to calculate \eqn{\Psi}}

\item{la1,la2}{Lagrange multipliers}

\item{Z}{partition function}

\item{S0}{Total number of species}

\item{N0}{Total number of individuals}

\item{E0}{Total metabolic rate}
}
\value{
numeric vector of length equal to length of \code{e}
}
\description{
\code{metePsi} is a low level function to calculate the value of
\eqn{\Psi(e | N_0, S_0, E_0)} (the distribution of metabolic rates/power across all individuals in a commmunity) at the given value of \code{e}; vectorized in \code{e}.
}
\details{
Typically only used in \code{ipd.meteESF} and not called by the user.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
metePsi(1:10,
        esf1$La[1],esf1$La[2],
        esf1$Z,esf1$state.var['S0'],
        esf1$state.var['N0'],
        esf1$state.var['E0'])
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
\code{ipd.mete}
}
\keyword{manip}

