% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_forest_plot.R
\name{forest.data.frame}
\alias{forest.data.frame}
\title{Forest plots for \dQuote{data.frame} objects}
\usage{
\method{forest}{data.frame}(
  x,
  layout = "meta",
  measure = "auto",
  leftcols = NULL,
  leftlabs = NULL,
  rightcols = NULL,
  rightlabs = NULL,
  digits = 2,
  smlab = "",
  xlab = NULL,
  type.study = "square",
  print.classes = FALSE,
  subgroup = NULL,
  subgroup.name = "",
  col.square = "gray",
  col.study = "black",
  col.square.lines = "black",
  fontsize = 12,
  spacing = 1,
  squaresize = 0.8/spacing,
  ...
)
}
\arguments{
\item{x}{an object of class \dQuote{umbrella} or a or \dQuote{data.frame} object returned by the \code{umbrella()} or \code{add.evidence()} functions.}

\item{layout}{type of layout of the plot ("meta", "JAMA" or "RevMan5").}

\item{measure}{type of effect size used in the plot ("eG", "eOR", "raw" or "auto"). Default is the most frequently used effect size measure.}

\item{leftcols}{vector of columns contained in the object passed to the \code{x} argument, used to specify columns which are printed on the left side of the forest plot.}

\item{leftlabs}{vector of column names used to specify column names printed on the left side of the forest plot.}

\item{rightcols}{vector of columns contained in the object passed to the \code{x} argument, used to specify columns which are printed on the right side of the forest plot.}

\item{rightlabs}{vector of column names used to specify column names printed on the left side of the forest plot.}

\item{digits}{number of digits to display}

\item{smlab}{character string describing the title of the plot}

\item{xlab}{character string describing the x-axis title}

\item{type.study}{the shape used to depict the pooled effect size (must be either "square", "diamond", or "predict")}

\item{print.classes}{a vector of classes. Only factors reaching these classes will be displayed on the plot. These classes must be "I", "II", "III", "IV" and/or "ns" for the "Ioannidis" classification, or "High", "Moderate", "Weak" and/or "Very weak" for the "GRADE" classification, or "I", "II", "III", "IV", and/or "V" for the "Personalized" classification}

\item{subgroup}{a character variable indicating the name of the column that should be used as header for creating subgroups between the factors}

\item{subgroup.name}{a character variable displayed just before each modality of the subgroup variable}

\item{col.square}{The colour for squares reflecting study's weight in the meta-analysis.}

\item{col.study}{The colour for individual study results and confidence limits.}

\item{col.square.lines}{The colour for the outer lines of squares reflecting study weight in the meta-analysis.}

\item{fontsize}{The size of text (in points)}

\item{spacing}{A numeric variable determining line spacing in a forest plot.}

\item{squaresize}{A numeric variable used to increase or decrease the size of squares in the forest plot.}

\item{...}{additional arguments that can be passed to the forest.umbrella function}
}
\value{
Return a forest plot of the pooled effect sizes, along with additional information
}
\description{
Draw a forest plot of the factors included in an umbrella review.
This function is now a wrapper around the amazing forest.meta function designed by
Guido Schwarzer and Gerta Rucker.
You can thus add any other arguments available in the forest.meta function but not detailed here.
}
\details{
The function allows to have a visualization of the results of an umbrella review.
Various parameters, such as the type of effect size displayed, the restriction to some classes or the color of the dots, allows to simplify the visualization.
}
\keyword{hplot}
\keyword{internal}
