% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_forest_plot.R
\name{forest.umbrella}
\alias{forest.umbrella}
\title{Forest plots for \dQuote{umbrella} objects}
\usage{
\method{forest}{umbrella}(
  x,
  measure = "eG",
  main_title = NA,
  main_value = NA,
  main_x_axis = NA,
  max.value = NULL,
  print.classes = NULL,
  col_sig = c("#252525", "#252525"),
  log_cex_dots = FALSE,
  fix_size_dots = NA,
  xlim = NULL,
  xlim_main_title = 0,
  xlim_value = 2.1,
  xlim_factor = -2.1,
  ylim_correction_value = 0,
  ylim_correction_text = 0,
  cex_title = 1.4,
  cex_text_header = 1,
  cex_text = 0.9,
  cex_value_header = 1,
  cex_value = 0.9,
  cex_x_axis = 1.1,
  cex_x_axis_value = 0.8,
  cex_dots = 1.2,
  col_title = "#1D1D1D",
  col_text_header = "#252525",
  col_text = "#252525",
  col_value_header = "#252525",
  col_value = "#252525",
  col_x_axis = "#252525",
  col_dots = "#252525",
  col_lines = "#252525",
  pos_value = "left-align",
  pos_text = "right-align",
  add_columns = NULL,
  main_add_columns = NA,
  xlim_add_columns = NA,
  x_lim_adj = 0,
  y_lim_adj = 0,
  x_axis_adj = 0,
  ...
)
}
\arguments{
\item{x}{an object of class \dQuote{umbrella}.}

\item{measure}{type of effect size used in the plot. Default is equivalent Hedges' g (\code{"eG"}). Alternatively, equivalent Odds Ratio (\code{"eOR"}) can be used.}

\item{main_title}{the title of the plot}

\item{main_value}{a title for the header of the 'value' column.}

\item{main_x_axis}{title of the x-axis}

\item{max.value}{the maximum value that will be plotted on the x-axis.
Must be strictly superior to 1 when equivalent odds ratio (eOR) measure is used, and strictly superior to 0 when SMD measure is used.
Note that minimum value will be automatically set to the inverse of \code{max.value} for eOR measure and to \code{- max.value} for SMD measure.}

\item{print.classes}{a vector of classes. Only factors reaching these classes will be displayed on the plot.
These classes must be:
\itemize{
\item "I", "II", "III", "IV" and/or "ns" for the "Ioannidis" classification
\item "High", "Moderate", "Weak" and/or "Very weak" for the "GRADE" classification
\item "I", "II", "III", "IV", and/or "V" for the "Personalized" classification
}}

\item{col_sig}{a vector of two colors. Statistically significant factors are displayed using these colors:
\itemize{
\item Protective factors (i.e., with an eOR < 1 or an SMD < 0) are displayed with the first color
\item Risk factors (i.e., with an eOR >= 1 or an SMD >= 0) will be displayed with the second color.
\item Non-significant factors are displayed with the color indicated in the 'col_dots' argument.
}}

\item{log_cex_dots}{a logical value indicating whether the logarithm of the size of the dot should be used (should be TRUE or FALSE). When set as TRUE, this argument allows to reduce the disparities in the size of the dots between factors.}

\item{fix_size_dots}{a unique positive numeric value that is used to fix the size of all dots}

\item{xlim}{a vector containing the limits of the x-axis (x1, x2) of the plot.}

\item{xlim_main_title}{position of the title of the plot on the x-axis.}

\item{xlim_value}{position of the 'value' column on the x-axis.}

\item{xlim_factor}{position of the 'factor' column on the x-axis.}

\item{ylim_correction_value}{when the position of columns is modified (e.g., "right-align" versus "center"), the height of the columns can be slighlty modified. This correction value allows to adjust the height of the 'value' column.}

\item{ylim_correction_text}{when the position of columns is modified (e.g., "right-align" versus "center"), the height of the columns can be slighlty modified. This correction value allows to adjust the height of the 'factor' column and to any new column added to the plot.}

\item{cex_title}{numeric value indicating the amount by which title text should be scaled relative to the default.}

\item{cex_text_header}{numeric value indicating the amount by which the text of the header of the 'factor' column and of any column added to the plot should be scaled relative to the default.}

\item{cex_text}{numeric value indicating the amount by which the text of the 'factor' column and of any column added to the plot should be scaled relative to the default.}

\item{cex_value_header}{numeric value indicating the amount by which the text of the header of the 'value' column should be scaled relative to the default.}

\item{cex_value}{numeric value indicating the amount by which the text of the 'value' column should be scaled relative to the default.}

\item{cex_x_axis}{numeric value indicating the amount by which the text of the x-axis title should be scaled relative to the default.}

\item{cex_x_axis_value}{numeric value indicating the amount by which the text of the x-axis values should be scaled relative to the default.}

\item{cex_dots}{numeric value indicating the amount by which dot size should be scaled relative to the default.}

\item{col_title}{color of the font of the title.}

\item{col_text_header}{color of the font of the header of the 'factor' column and to any column added to the plot.}

\item{col_text}{color of the font of the 'factor' column and of any column added to the plot.}

\item{col_value_header}{color of the header of the 'value' column.}

\item{col_value}{color of the font of the 'value' column.}

\item{col_x_axis}{color of the font of the x-axis.}

\item{col_dots}{color of the dots.}

\item{col_lines}{color of the lines.}

\item{pos_value}{type of centering of the column displaying the values. Must be either "left-align", "center", or "right-align".}

\item{pos_text}{type of centering of the 'factor' column. Must be either "left-align", "center", or "right-align".}

\item{add_columns}{a vector/dataframe containing the columns that should be added to the plot. The number of rows of the columns added to the plot should be equal to the number of factors.}

\item{main_add_columns}{a vector containing the name of the header of the new columns added to the plot (default is the name of the columns in the dataset).}

\item{xlim_add_columns}{position of the new columns added on x-axis. Should be a numeric vector containing the exact same number values as the number of columns added. Mandatory when columns are added to the plot.}

\item{x_lim_adj}{a numeric value that can be used to adjust the size of the window of the plot on the x-axis.}

\item{y_lim_adj}{a numeric value that can be used to adjust the size of the window of the plot on the y-axis.}

\item{x_axis_adj}{a numeric value that can be used to adjust the height of the space between the x-axis and the title of the x-axis.}

\item{...}{additional arguments that can be passed to the forest.umbrella function}
}
\value{
In addition to the plot, the function returns a list including:
\itemize{
\item a dataset with the factors, their class and their effect size. Particularly useful when adding a column via the 'add_columns' argument to obtain the ordering of the factors in the plot. See the vignette dedicated to the forest plots for a concrete example.
\item the optimal width and height of the plot, useful when calling the function \code{pdf()} or \code{png()}.
}
}
\description{
Draw a forest plot of the factors included in an umbrella review.
The basic version of this plot contains three parts:
\itemize{
\item a column displaying the name of the factors (referred to as the \code{'factor'} column).
\item a graphical representation of the pooled effect sizes and 95\% CI of the factors.
\item a column displaying the numeric values of the pooled effect size and 95\% CI of the factors (referred to as the \code{'value'} column).
}
}
\details{
The function allows to have a visualization of the results of an umbrella review.
Various parameters, such as the type of effect size displayed, the restriction to some classes or the color of the dots, allows to simplify the visualization.
}
\examples{
\donttest{
### perform an umbrella review of various datasets
umbs <- union.umbrella(union.umbrella(union.umbrella(union.umbrella(
umbrella(df.OR), umbrella(df.SMD)), umbrella(df.RR)), umbrella(df.IRR)), umbrella(df.HR))

### stratify the evidence according to some Personalized criteria
umbs.crit <- add.evidence(umbs, criteria = "Personalized",
  class_I = c(n_cases = 1000, p_value = 1e-6, esb_p = 0.10, egger_p = 0.10,
  I2 = 0.25, pi = "notnull"),
  class_II = c(n_cases = 1000, p_value = 1e-6, largest_CI = "notnull"),
  class_III = c(n_cases = 1000, p_value = 1e-3),
  class_IV = c(p_value = 5e-2))
sum.umbs <- summary.umbrella(umbs.crit)

### generate a forest plot of each factor included in the umbrella review
forest.umbrella(umbs.crit, max.value = 7,
                main_title = "Plot of the umbrella review")
}
}
\references{
Tortella-Feliu, M. and Fullana, M.A., Perez-Vigil, A., Torres, X., Chamorro, J., and Littarelli, S.A., ..., & Radua, J. (2019). Risk Factors for Posttraumatic Stress Disorder: An Umbrella Review of Systematic Reviews and Meta-Analyses.
\emph{Neuroscience & Biobehavioral Reviews}, \bold{107}, 154--165.
}
