% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{adjusted_rand_index_heatmap}
\alias{adjusted_rand_index_heatmap}
\title{Heatmap of pairwise adjusted rand indices between solutions}
\usage{
adjusted_rand_index_heatmap(
  aris,
  order = NULL,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  log_graph = FALSE,
  scale_diag = "none",
  min_colour = "#282828",
  max_colour = "firebrick2",
  col = circlize::colorRamp2(c(min(aris), max(aris)), c(min_colour, max_colour)),
  ...
)
}
\arguments{
\item{aris}{Matrix of adjusted rand indices from \code{calc_aris()}}

\item{order}{Numeric vector containing row order of the heatmap.}

\item{cluster_rows}{Whether rows should be clustered.}

\item{cluster_columns}{Whether columns should be clustered.}

\item{log_graph}{If TRUE, log transforms the graph.}

\item{scale_diag}{Method of rescaling matrix diagonals. Can be "none"
(don't change diagonals), "mean" (replace diagonals with average value of
off-diagonals), or "zero" (replace diagonals with 0).}

\item{min_colour}{Colour used for the lowest value in the heatmap.}

\item{max_colour}{Colour used for the highest value in the heatmap.}

\item{col}{Colour ramp to use for the heatmap.}

\item{...}{Additional parameters passed to \code{similarity_matrix_heatmap()},
the function that this function wraps.}
}
\value{
Returns a heatmap (class "Heatmap" from package ComplexHeatmap)
that displays the pairwise adjusted Rand indices (similarities) between
the cluster solutions of the provided solutions matrix.
}
\description{
Heatmap of pairwise adjusted rand indices between solutions
}
