% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hm_mean.R
\name{hm_mean}
\alias{hm_mean}
\title{Harmonic mean}
\usage{
hm_mean(x, ..., na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector or a data frame.}

\item{...}{Variables to compute the harmonic mean. If no variable is informed
and \code{x} is a data frame, all the numeric variables will be used.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before computation proceeds.}
}
\value{
The harmonic mean(s) of \code{x}. If \code{x} is a numeric vector, the
  function returns a numeric value. If a data frame is used then a numeric
  vector with the harmonic mean for each variable is returned.
}
\description{
Helper function to compute the harmonic mean. The harmonic mean is the
reciprocal of the arithmetic mean of the reciprocals.
}
\note{
Not useful if there are elements with values \code{<=0}.
}
\examples{
num <- c(1:10, 50)
hm_mean(num)

num_df <- make_mat(data_ge, ENV, GEN, GY)
hm_mean(num_df)
}
\seealso{
\code{\link{gm_mean}}
}
