% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tukey_hsd.R
\name{tukey_hsd}
\alias{tukey_hsd}
\title{Tukey Honest Significant Differences}
\usage{
tukey_hsd(model, ..., out = "long")
}
\arguments{
\item{model}{an object of class \code{aov} or \code{lm}.}

\item{...}{other arguments passed to the function
\code{\link[stats:TukeyHSD]{stats::TukeyHSD()}}. These include:
\itemize{
\item \strong{which}: A character vector listing terms in the fitted model for which the
intervals should be calculated. Defaults to all the terms.
\item \strong{ordered}: A logical value indicating if the levels of the factor should be
ordered according to increasing average in the sample before taking
differences. If ordered is true then the calculated differences in the means
will all be positive. The significant differences will be those for which the
lwr end point is positive.
}}

\item{out}{The format of outputs. If \code{out = "long"} a 'long' format
(tibble) is returned. If \code{out = "wide"}, a matrix with the adjusted
p-values for each term is returned.}
}
\value{
A tibble data frame containing the results of the pairwise
comparisons (if \code{out = "long"}) or a "list-columns" with p-values for
each term (if \code{out = "wide"}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function to perform Tukey post-hoc tests. It is used in \link{gafem}.
}
\examples{
\donttest{
library(metan)
mod <- lm(PH ~ GEN + REP, data = data_g)
tukey_hsd(mod)
tukey_hsd(mod, out = "wide")
}
}
