% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_compare.R
\name{rate_compare_sum}
\alias{rate_compare_sum}
\title{Unstratified and stratified Miettinen and Nurminen test in
aggregate data level}
\usage{
rate_compare_sum(
  n0,
  n1,
  x0,
  x1,
  strata = NULL,
  delta = 0,
  weight = c("ss", "equal", "cmh"),
  test = c("one.sided", "two.sided"),
  bisection = 100,
  eps = 1e-06,
  alpha = 0.05
)
}
\arguments{
\item{n0, n1}{The sample size in the control group and experimental group,
separately. The length should be the same as the length for
\code{x0/x1} and \code{strata}.}

\item{x0, x1}{The number of events in the control group and
experimental group, separately. The length should be the same
as the length for \code{n0/n1} and \code{strata}.}

\item{strata}{A vector of stratum indication to be used in the analysis.
If \code{NULL} or the length of unique values of \code{strata} equals to 1,
it is unstratified MN analysis. Otherwise, it is stratified MN analysis.
The length of \code{strata} should be the same as the length for
\code{x0/x1} and \code{n0/n1}.}

\item{delta}{A numeric value to set the difference of two groups
under the null.}

\item{weight}{Weighting schema used in stratified MN method.
Default is \code{"ss"}:
\itemize{
\item \code{"equal"} for equal weighting.
\item \code{"ss"} for sample size weighting.
\item \code{"cmh"} for Cochran-Mantel-Haenszel's weights.
}}

\item{test}{A character string specifying the side of p-value,
must be one of \code{"one.sided"}, or \code{"two.sided"}.}

\item{bisection}{The number of sections in the interval used in
bisection method. Default is 100.}

\item{eps}{The level of precision. Default is 1e-06.}

\item{alpha}{Pre-defined alpha level for two-sided confidence interval.}
}
\value{
A data frame with the test results.
}
\description{
Unstratified and stratified Miettinen and Nurminen test in
aggregate data level
}
\examples{
# Conduct the stratified MN analysis with sample size weights
treatment <- c(rep("pbo", 100), rep("exp", 100))
response <- c(rep(0, 80), rep(1, 20), rep(0, 40), rep(1, 60))
stratum <- c(rep(1:4, 12), 1, 3, 3, 1, rep(1:4, 12), rep(1:4, 25))
n0 <- sapply(split(treatment[treatment == "pbo"], stratum[treatment == "pbo"]), length)
n1 <- sapply(split(treatment[treatment == "exp"], stratum[treatment == "exp"]), length)
x0 <- sapply(split(response[treatment == "pbo"], stratum[treatment == "pbo"]), sum)
x1 <- sapply(split(response[treatment == "exp"], stratum[treatment == "exp"]), sum)
strata <- c("a", "b", "c", "d")
rate_compare_sum(
  n0, n1, x0, x1,
  strata,
  delta = 0,
  weight = "ss",
  test = "one.sided",
  alpha = 0.05
)
}
\references{
Miettinen, O. and Nurminen, M, Comparative Analysis of Two Rates.
\emph{Statistics in Medicine}, 4(2):213--226, 1985.
}
