% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/covariance_commonControl.R
\name{covariance_commonControl}
\alias{covariance_commonControl}
\title{Generates a sampling variance-covariance matrix for modeling dependencies
among effect sizes due to sharing a common control.}
\usage{
covariance_commonControl(aDataFrame, control_ID, X_t, SD_t, N_t, X_c, SD_c, N_c,
  metric = "RR")
}
\arguments{
\item{aDataFrame}{A data frame containing columns with all study parameters
used to estimate effect sizes (e.g., means, SD, N's for treatment and
control groups).  Must also contain a column that codes which effect sizes
share a common control.  See example below.}

\item{control_ID}{Label of the column that codes groups of effect sizes that
share the mean, SD, and N of a control group.}

\item{X_t}{Column label for the means of (t)reatment group used to estimate the
effect size.}

\item{SD_t}{Column label for the standard deviations (SD) of the treatment
group used to estimate the effect size.}

\item{N_t}{Column label for the sample size (N) of the treatment group
used to estimate the effect size.}

\item{X_c}{Column label for the means of (c)ontrol group used to estimate the
effect size.}

\item{SD_c}{Column label for the standard deviations (SD) of the control
group used to estimate the effect size.}

\item{N_c}{Column label for the sample size (N) of the control group
used to estimate the effect size.}

\item{metric}{Option to designate which effect size metric for which the
   common control VCV matrix is to be estimated.  Default is "RR" for log
   response ratio.}
}
\value{
A K by K sampling variance-covariance matrix and a data frame aligned
   with the block diagonal design of the sampling matrix.
}
\description{
Generates K by K sampling variance-covariance (VCV) matrix that models the
dependencies that arise due to using the same control group study parameters
when estimating multiple effect sizes.  This VCV matrix can then be used in
meta-analysis.  Currently only supports VCV calculation for log response
ratios (see Lajeunesse 2011).
}
\references{
Lajeunesse, M.J. 2011. On the meta-analysis of response ratios for
    studies with correlated and multi-group designs. Ecology 92: 2049-2055.
}

