% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{fes2}
\alias{fes2}
\title{Calculate free energy surface by conventional algorithm}
\usage{
fes2(hills, imin = 1, imax = NULL, xlim = NULL, ylim = NULL,
  npoints = 256)
}
\arguments{
\item{hills}{hillsfile object.}

\item{imin}{index of a hill from which summation starts (default 1).}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}

\item{xlim}{numeric vector of length 2, giving the CV1 coordinates range.}

\item{ylim}{numeric vector of length 2, giving the CV2 coordinates range.}

\item{npoints}{resolution of the free energy surface in number of points.}
}
\value{
fes object.
}
\description{
`fes2` sums up hills using slow conventional algorithm. It can be used
as a reference or when hill widths are variable.
}
\examples{
tfes<-fes2(acealanme, imax=1000)
}
