% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_builder.R
\name{spec_type_to_value_spec}
\alias{spec_type_to_value_spec}
\title{Spec to value_spec}
\usage{
spec_type_to_value_spec(
  doc,
  cols = c(dataset = "[D|d]ataset|[D|d]omain", variable = "[N|n]ame|[V|v]ariables?",
    origin = "[O|o]rigin", type = "[T|t]ype", code_id = "[C|c]odelist|Controlled Term",
    where = "[W|w]here", derivation_id = "[M|m]ethod"),
  sheet = NULL,
  where_sep_sheet = TRUE,
  where_cols = c(id = "ID", where = c("Variable", "Comparator", "Value")),
  var_sheet = "[V|v]ar"
)
}
\arguments{
\item{doc}{Named list of datasets @seealso \code{\link[=read_all_sheets]{read_all_sheets()}} for exact
format}

\item{cols}{Named vector of column names. The column names can be regular
expressions for more flexibility. But, the names must follow the given
pattern}

\item{sheet}{Regular expression for the sheet name}

\item{where_sep_sheet}{Boolean value to control if the where information in a
separate dataset. If the where information is on a separate sheet, set to
true and provide the column information with the \code{where_cols} inputs.}

\item{where_cols}{Named list with an id and where field. All columns in the
where field will be collapsed together}

\item{var_sheet}{Name of sheet with the Variable information on it. Metacore
expects each variable will have a row in the value_spec. Because many
specification only have information in the value tab this is added. If the
information already exists in the value tab of your specification set to
NULL}
}
\value{
a dataset formatted for the metacore object
}
\description{
Creates the value_spec from a list of datasets (optionally filtered by the
sheet input). The named vector \code{cols} is used to determine which is the
correct sheet and renames the columns
}
\seealso{
Other spec builder: 
\code{\link{spec_type_to_codelist}()},
\code{\link{spec_type_to_derivations}()},
\code{\link{spec_type_to_ds_spec}()},
\code{\link{spec_type_to_ds_vars}()},
\code{\link{spec_type_to_var_spec}()}
}
\concept{spec builder}
