% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_phyloseq.R
\name{as_phyloseq}
\alias{as_phyloseq}
\title{Convert taxmap to phyloseq}
\usage{
as_phyloseq(
  obj,
  otu_table = NULL,
  otu_id_col = "otu_id",
  sample_data = NULL,
  sample_id_col = "sample_id",
  phy_tree = NULL
)
}
\arguments{
\item{obj}{The taxmap object.}

\item{otu_table}{The table in `obj$data` with OTU counts. Must be one of the following:
\describe{
  \item{\code{NULL}}{Look for a table named "otu_table" in `obj$data` with taxon IDs, OTU IDs, and OTU counts. If it exists, use it.}
  \item{\code{character}}{The name of the table stored in `obj$data` with taxon IDs, OTU IDs, and OTU counts}
  \item{\code{data.frame}}{A table with taxon IDs, OTU IDs, and OTU counts}
  \item{\code{FALSE}}{Do not include an OTU table, even if "otu_table" exists in `obj$data`}
}}

\item{otu_id_col}{The name of the column storing OTU IDs in the otu table.}

\item{sample_data}{A table containing sample data with sample IDs matching
  column names in the OTU table. Must be one of the following:
\describe{
  \item{\code{NULL}}{Look for a table named "sample_data" in `obj$data`. If it exists, use it.}
  \item{\code{character}}{The name of the table stored in `obj$data` with sample IDs}
  \item{\code{data.frame}}{A table with sample IDs}
  \item{\code{FALSE}}{Do not include a sample data table, even if "sample_data" exists in `obj$data`}
}}

\item{sample_id_col}{The name of the column storing sample IDs in the sample data table.}

\item{phy_tree}{A phylogenetic tree of class \code{\link[ape]{phylo}} from
  the \code{\link{ape}} package with tip labels matching OTU ids. Must be one of the following:
\describe{
  \item{\code{NULL}}{Look for a tree named "phy_tree" in `obj$data` with tip labels matching OTU ids. If it exists, use it.}
  \item{\code{character}}{The name of the tree stored in `obj$data` with tip labels matching OTU ids.}
  \item{\code{\link[ape]{phylo}}}{A tree with tip labels matching OTU ids.}
  \item{\code{FALSE}}{Do not include a tree, even if "phy_tree" exists in `obj$data`}
}}
}
\description{
Convert a taxmap object to a phyloseq object.
}
\examples{
\dontrun{
# Install phyloseq to get example data
# if (!require("BiocManager", quietly = TRUE))
#   install.packages("BiocManager")
# 
# BiocManager::install("phyloseq")

# Parse example dataset
library(phyloseq)
data(GlobalPatterns)
x <- parse_phyloseq(GlobalPatterns)

# Convert back to a phylseq object
as_phyloseq(x)

}
}
