% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabias.R
\name{metabias.meta}
\alias{metabias.meta}
\alias{metabias}
\alias{metabias.default}
\alias{print.metabias}
\title{Test for funnel plot asymmetry}
\usage{
\method{metabias}{meta}(
  x,
  method.bias = x$method.bias,
  plotit = FALSE,
  correct = FALSE,
  k.min = 10,
  ...
)

\method{print}{metabias}(
  x,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = max(gs("digits.pval"), 2),
  digits.se = gs("digits.se"),
  digits.tau2 = gs("digits.tau2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  text.tau2 = gs("text.tau2"),
  ...
)

metabias(x, ...)

\method{metabias}{default}(
  x,
  seTE,
  method.bias = "Egger",
  plotit = FALSE,
  correct = FALSE,
  k.min = 10,
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta} or estimated treatment
effect in individual studies.}

\item{method.bias}{A character string indicating which test is to
be used (see Details), can be abbreviated.}

\item{plotit}{A logical indicating whether a plot should be
produced (see Details).}

\item{correct}{A logical indicating whether a continuity corrected
statistic is used for rank correlation tests.}

\item{k.min}{Minimum number of studies to perform test for funnel
plot asymmetry.}

\item{\dots}{Additional arguments passed on to
\code{\link[metafor]{rma.uni}}.}

\item{digits}{Minimal number of significant digits for estimates,
see \code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-value of test for test of funnel plot asymmetry, see
\code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of test for test of funnel plot asymmetry, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
errors, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
residual heterogeneity variance, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{text.tau2}{Text printed to identify residual heterogeneity
variance \eqn{\tau^2}.}

\item{seTE}{Standard error of estimated treatment effect (mandatory
if \code{x} not of class \code{meta}).}
}
\value{
A list with class \code{metabias} containing the following
components if a test for funnel plot asymmetry is conducted:
\item{statistic}{Test statistic.}
\item{df}{The degrees of freedom of the test statistic in
  the case that it follows a t distribution.}
\item{pval}{The p-value for the test.}
\item{estimate}{Estimates used to calculate test statisic.}
\item{method}{A character string indicating what type of test was
  used.}
\item{title}{Title of Cochrane review.}
\item{complab}{Comparison label.}
\item{outclab}{Outcome label.}
\item{var.model}{A character string indicating whether none,
  multiplicative, or additive residual heterogeneity variance was
  assumed.}
\item{method.bias}{As defined above.}
\item{x}{Meta-analysis object.}
\item{version}{Version of R package \bold{meta} used to create
  object.}

Or a list with the following elements if test is not conducted due
to the number of studies:
\item{k}{Number of studies in meta-analysis.}
\item{k.min}{Minimum number of studies to perform test for funnel
  plot asymmetry.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
}
\description{
Test for funnel plot asymmetry, based on rank correlation or linear
regression method.
}
\details{
Functions to conduct rank correlation or linear regression tests
for funnel plot asymmetry.

\subsection{Classic generic tests}{
The following tests are generic tests for funnel plot asymmetry
which only require estimates of the treatment effect and
corresponding standard errors. Accordingly, these are the only
tests provided by R function \code{metabias.default}.

If argument \code{method.bias} is \code{"Begg"}, the test statistic
is based on the rank correlation between standardised treatment
estimates and variance estimates of estimated treatment effects;
Kendall's tau is used as correlation measure (Begg & Mazumdar,
1994). The test statistic follows a standard normal
distribution. By default (if \code{correct} is FALSE), no
continuity correction is utilised (Kendall & Gibbons, 1990).

If argument \code{method.bias} is \code{"Egger"}, the test
statistic is based on a weighted linear regression of the treatment
effect on its standard error (Egger et al., 1997). The test
statistic follows a t distribution with \code{number of studies -
2} degrees of freedom.

If argument \code{method.bias} is \code{"Thompson"}, the test
statistic is based on a weighted linear regression of the treatment
effect on its standard error using an additive between-study
variance component denoted as methods (3a) - (3d) in Thompson &
Sharp (1999). The test statistic follows a t distribution with
\code{number of studies - 2} degrees of freedom.  }

\subsection{Tests for meta-analysis with binary outcomes}{
The following tests for funnel plot asymmetry are only available
for meta-analyses comparing two binary outcomes, i.e. meta-analyses
generated with the \code{metabin} function. The only exception is
the test by Peters et al. (2006) which can also be used in a
meta-analysis of single proportions generated with \code{metaprop}.

If argument \code{method.bias} is \code{"Harbord"}, the test
statistic is based on a weighted linear regression utilising
efficient score and score variance (Harbord et al., 2006,
2009). The test statistic follows a t distribution with
\code{number of studies - 2} degrees of freedom.

In order to calculate an arcsine test for funnel plot asymmetry
(Rücker et al., 2008), one has to use the \code{metabin} function
with argument \code{sm = "ASD"} as input to the \code{metabias}
command. The three arcsine tests described in Rücker et al. (2008)
can be calculated by setting \code{method.bias} to \code{"Begg"},
\code{"Egger"} and \code{"Thompson"}, respectively.

If argument \code{method.bias} is \code{"Macaskill"}, the test
statistic is based on a weighted linear regression of the treatment
effect on the total sample size with weights reciprocal to the
variance of the average event probability (Macaskill et al., 2001,
\emph{method FPV}). The test statistic follows a t distribution
with \code{number of studies - 2} degrees of freedom.

If argument \code{method.bias} is \code{"Peters"}, the test
statistic is based on a weighted linear regression of the treatment
effect on the inverse of the total sample size with weights
reciprocal to the variance of the average event probability (Peters
et al., 2006). The test statistic follows a t distribution with
\code{number of studies - 2} degrees of freedom. Note, this test is
a variant of Macaskill et al. (2001), \emph{method FPV}, using the
inverse sample size as covariate.

If argument \code{method.bias} is \code{"Schwarzer"}, the test
statistic is based on the rank correlation between a standardised
cell frequency and the inverse of the variance of the cell
frequency; Kendall's tau is used as correlation measure (Schwarzer
et al., 2007). The test statistic follows a standard normal
distribution. By default (if \code{correct} is FALSE), no
continuity correction is utilised (Kendall & Gibbons, 1990).

Finally, for meta-analysis of diagnostic test accuracy studies, if
argument \code{method.bias} is \code{"Deeks"}, the test statistic
is based on a weighted linear regression of the log diagnostic odds
ratio on the inverse of the squared effective sample size using the
effective sample size as weights (Deeks et al., 2005). The test
statistic follows a t distribution with \code{number of studies -
2} degrees of freedom.
}

\subsection{Test for the standardised mean difference}{
If argument \code{method.bias} is \code{"Pustejovsky"}, the test
statistic is based on a weighted linear regression of the treatment
effect on the square root of the sum of the inverse group sample
sizes using the treatment effect variance as weights (Pustejovsky &
Rodgers, 2019). The test statistic follows a t distribution with
\code{number of studies - 2} degrees of freedom.
}

\subsection{Recommendations and default settings}{
Following recommendations by Sterne et al. (2011), by default, a
test for funnel plot asymmetry is only conducted if the number of
studies is ten or larger (argument \code{k.min = 10}). This
behaviour can be changed by setting a smaller value for argument
\code{k.min}. Note, the minimum number of studies is three.

If argument \code{method.bias} is missing, the Harbord test
(\code{method.bias = "Harbord"}) is used in meta-analyses with a binary
outcome for the odds ratio and Deeks' test (\code{method.bias = "Deeks"})
for the diagnostic odds ratios. In all other settings, the Egger test
(\code{method.bias = "Egger"}) is used (Sterne et al., 2011).

No test for funnel plot asymmetry is conducted in meta-analyses
with subgroups.
}

If argument \code{plotit = TRUE}, a scatter plot is shown if
argument \code{method.bias} is equal to \code{"Begg"},
\code{"Egger"}, \code{"Thompson"}, \code{"Harbord"}, or
\code{"Deeks"}.
}
\examples{
data(Olkin1995)
m1 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
  data = Olkin1995, subset = 1:10, sm = "RR", method = "I")

metabias(m1)
metabias(m1, plotit = TRUE)

metabias(m1, method.bias = "Begg")
metabias(m1, method.bias = "Begg", correct = TRUE)

metabias(m1, method.bias = "Schwarzer")
metabias(m1, method.bias = "Egger")$pval

# Arcsine test (based on linear regression)
#
m1.as <- update(m1, sm = "ASD")
metabias(m1.as)
# Same result (using function metabias.default)
metabias(m1.as$TE, m1.as$seTE)

# No test for funnel plot asymmetry calculated
#
m2 <- update(m1, subset = 1:5)
metabias(m2)

m3 <- update(m1, subset = 1:2)
metabias(m3)

# Test for funnel plot asymmetry calculated (use of argument k.min)
#
metabias(m2, k.min = 5)

}
\references{
Begg CB & Mazumdar M (1994):
Operating characteristics of a rank correlation test for
publication bias.
\emph{Biometrics},
\bold{50}, 1088--101

Deeks JJ, Macaskill P, Irwig L (2005):
The performance of tests of publication bias and other sample size
effects in systematic reviews of diagnostic test accuracy was
assessed.
\emph{Journal of Clinical Epidemiology},
\bold{58}:882--93

Egger M, Smith GD, Schneider M & Minder C (1997):
Bias in meta-analysis detected by a simple, graphical test.
\emph{British Medical Journal},
\bold{315}, 629--34

Harbord RM, Egger M & Sterne J (2006):
A modified test for small-study effects in meta-analyses of
controlled trials with binary endpoints.
\emph{Statistics in Medicine},
\bold{25}, 3443--57

Harbord RM, Harris RJ, Sterne JAC (2009):
Updated tests for small-study effects in meta–analyses.
\emph{The Stata Journal},
\bold{9}, 197--210

Kendall M & Gibbons JD (1990):
\emph{Rank Correlation Methods}.
London: Edward Arnold

Macaskill P, Walter SD, Irwig L (2001):
A comparison of methods to detect publication bias in
meta-analysis.
\emph{Statistics in Medicine},
\bold{20}, 641--54

Peters JL, Sutton AJ, Jones DR, Abrams KR & Rushton L (2006):
Comparison of two methods to detect publication bias in
meta-analysis.
\emph{Journal of the American Medical Association},
\bold{295}, 676--80

Pustejovsky JE, Rodgers MA (2019):
Testing for funnel plot asymmetry of standardized mean differences.
\emph{Research Synthesis Methods},
\bold{10}, 57--71

Rücker G, Schwarzer G, Carpenter JR (2008):
Arcsine test for publication bias in meta-analyses with binary
outcomes.
\emph{Statistics in Medicine},
\bold{27}, 746--63

Schwarzer G, Antes G & Schumacher M (2007):
A test for publication bias in meta-analysis with sparse binary
data.
\emph{Statistics in Medicine},
\bold{26}, 721--33

Sterne, JAC et al. (2011):
Recommendations for examining and interpreting funnel plot
asymmetry in meta-analyses of randomised controlled trials.
\emph{BMJ (Clinical research ed.)},
\bold{343}, 1

Thompson SG & Sharp, SJ (1999):
Explaining heterogeneity in meta-analysis: a comparison of methods,
\emph{Statistics in Medicine},
\bold{18}, 2693--708
}
\seealso{
\code{\link{funnel}}, \code{\link{funnel.meta}},
  \code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
