% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.longarm.R
\name{subset.longarm}
\alias{subset.longarm}
\title{Return subset of longarm object}
\usage{
\method{subset}{longarm}(x, subset, ...)
}
\arguments{
\item{x}{An object of class \code{longarm}.}

\item{subset}{A logical expression indicating elements or rows to
keep: missing values are taken as false.}

\item{\dots}{Additional arguments.}
}
\value{
A \code{\link{longarm}} object is returned.
}
\description{
The \code{subset} method returns a subset of a longarm object.
}
\examples{
# Artificial example with three studies
m <- metabin(1:3, 100:102, 4:6, 200:202, studlab = LETTERS[1:3])
# Transform data to long arm-based format
l1 <- longarm(m)
l1

# Subset without Study B
subset(l1, studlab != "B")

}
\seealso{
\code{\link{longarm}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
