% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smd2or.R
\name{smd2or}
\alias{smd2or}
\title{Conversion from standardised mean difference to log odds ratio}
\usage{
smd2or(
  smd,
  se.smd,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  method = "HH",
  backtransf = gs("backtransf"),
  ...
)
}
\arguments{
\item{smd}{Standardised mean difference(s) (SMD) or meta-analysis
object.}

\item{se.smd}{Standard error(s) of SMD (ignored if argument
\code{smd} is a meta-analysis object).}

\item{studlab}{An optional vector with study labels (ignored if
argument \code{smd} is a meta-analysis object).}

\item{data}{An optional data frame containing the study information
(ignored if argument \code{smd} is a meta-analysis object).}

\item{subset}{An optional vector specifying a subset of studies to
be used (ignored if argument \code{smd} is a meta-analysis
object).}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots (ignored if argument \code{smd} is a meta-analysis object).}

\item{method}{A character string indicating which method is used to
convert SMDs to log odds ratios. Either \code{"HH"} or
\code{"CS"}, can be abbreviated.}

\item{backtransf}{A logical indicating whether odds ratios (if
TRUE) or log odds ratios (if FALSE) should be shown in printouts
and plots.}

\item{\dots}{Additional arguments passed on to
\code{\link{metagen}} (ignored if argument \code{smd} is a
meta-analysis object).}
}
\value{
An object of class \code{"meta"} and \code{"metagen"}; see
\code{\link{metagen}}.
}
\description{
Conversion from standardised mean difference to log odds ratio
using method by Hasselblad & Hedges (1995) or Cox (1970).
}
\details{
This function implements the following methods for the conversion
from standardised mean difference to log odds ratio:
\itemize{
\item Hasselblad & Hedges (1995) assuming logistic distributions
  (\code{method == "HH"})
\item Cox (1970) and Cox & Snell (1989) assuming normal
  distributions (\code{method == "CS"})
}
Internally, \code{\link{metagen}} is used to conduct a
meta-analysis with the odds ratio as summary measure.

Argument \code{smd} can be either a vector of standardised mean
differences or a meta-analysis object created with
\code{\link{metacont}} or \code{\link{metagen}} and the
standardised mean difference as summary measure.

Argument \code{se.smd} is mandatory if argument \code{smd} is a
vector and ignored otherwise. Additional arguments in \code{\dots}
are only passed on to \code{\link{metagen}} if argument \code{smd}
is a vector.
}
\examples{
# Example from Borenstein et al. (2009), Chapter 7
#
mb <- smd2or(0.5, sqrt(0.0205), backtransf = FALSE)
# TE = log odds ratio; seTE = standard error of log odds ratio
data.frame(lnOR = round(mb$TE, 4), varlnOR = round(mb$seTE^2, 4))

# Use dataset from Fleiss (1993)
#
data(Fleiss1993cont)
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "SMD",
               studlab = paste(study, year))
smd2or(m1)

}
\references{
Borenstein M, Hedges LV, Higgins JPT, Rothstein HR (2009):
\emph{Introduction to Meta-Analysis}.
Chichester: Wiley

Cox DR (1970):
\emph{Analysis of Binary Data}.
London: Chapman and Hall / CRC

Cox DR, Snell EJ (1989):
\emph{Analysis of Binary Data} (2nd edition).
London: Chapman and Hall / CRC

Hasselblad V, Hedges LV (1995):
Meta-analysis of screening and diagnostic tests.
\emph{Psychological Bulletin},
\bold{117}, 167--78
}
\seealso{
\code{\link{or2smd}}, \code{\link{metacont}},
  \code{\link{metagen}}, \code{\link{metabin}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
