% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_retrieve.R
\name{mnet_retrieve}
\alias{mnet_retrieve}
\title{Retrieve Oklahoma Mesonet subdaily data}
\usage{
mnet_retrieve(
  stid,
  start_date = NULL,
  end_date = NULL,
  root_url = mnet_root_url(),
  site_info = NULL,
  file_cache = NULL,
  ask = !silent,
  silent = FALSE
)
}
\arguments{
\item{stid}{a character vector of four-digit station identifiers
for the Mesonet stations from which to download data}

\item{start_date}{the first date for which to download data specified in
Central Standard Time (i.e. "America/Costa_Rica") zone as a Date or POSIXt
object or a string with the format YYYY-MM-DD, where YYYY is the four-digit
year, MM is the two-digit numeric month and DD is the two-digit day of month}

\item{end_date}{the final date for which to download data specified in
Central Standard Time (i.e. "America/Costa_Rica") zone as a Date or POSIXt
object or a string with the format YYYY-MM-DD, where YYYY is the four-digit
year, MM is the two-digit numeric month and DD is the two-digit day of month}

\item{root_url}{the root url from which to download MTS files (see
\link[mesonet]{mnet_root_url})}

\item{site_info}{a data frame with site and soil information for each
Oklahoma Mesonet station as returned by \link[mesonet]{mnet_site_info}. If
NULL, \link[mesonet]{mnet_site_info} will be used to download this
information internally}

\item{file_cache}{a character string providing a path to the local Mesonet
file cache. If NULL, the function will search for the local file cache and
if not found will prompt the user to create one.}

\item{ask}{whether or not to ask about creating a local Mesonet file cache}

\item{silent}{whether to suppress output to terminal (TRUE) or allow output
to terminal (FALSE)}
}
\value{
A data frame with Oklahoma Mesonet data. See below for a list of
variables including column ID, name, unit and description:\tabular{llll}{
   \strong{ID} \tab \strong{Name} \tab \strong{Unit} \tab \strong{Description} \cr
   PRES \tab Station Atmospheric Pressure \tab kPa \tab 5-minute averaged atmospheric pressure. \cr
   RAIN \tab Precipitation \tab millimeters \tab Liquid precipitation accumulation since previous 5-min record. Frozen precipitation cannot be recorded until it melts; therefore, precipitation from snow may not be recorded until several days after the snow event. \cr
   RELH \tab Relative Humidity \tab percent \tab 5-minute averaged relative humidity at 1.5m. \cr
   SRAD \tab Solar Radiation \tab watts per square meter \tab 5-minute averaged downwelling global solar radiation. \cr
   STID \tab Station ID \tab  \tab Station ID \cr
   STNM \tab Station Number \tab  \tab Station Number \cr
   TA9M \tab Air Temperature at 9m \tab degrees Celsius \tab 5-minute averaged air temperature at 9m \cr
   TAIR \tab Air Temperature \tab degrees Celsius \tab 5-minute averaged air temperature at 1.5m. \cr
   TB05 \tab Temperature Under Bare Soil at 5cm \tab degrees Celsius \tab 15-minute averaged temperature under bare soil at 5cm. This variable is only available prior to December 1, 2013. \cr
   TB10 \tab Temperature Under Bare Soil at 10cm \tab degrees Celsius \tab 15-minute averaged temperature under bare soil at 10cm. \cr
   TIME \tab Time \tab minutes after base time \tab Minutes after base time (typically 0000 UTC) \cr
   TR05 \tab Soil Moisture Calibrated Delta-T at 5cm \tab degrees Celsius \tab 30-minute calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TR25 \tab Soil Moisture Calibrated Delta-T at 25cm \tab degrees Celsius \tab 30-minute calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TR60 \tab Soil Moisture Calibrated Delta-T at 60cm \tab degrees Celsius \tab 30-minute calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TR75 \tab Soil Moisture Calibrated Delta-T at 75cm \tab degrees Celsius \tab 30-minute calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TS05 \tab Temperature Under Native Vegetation at 5cm \tab degrees Celsius \tab 15-minute averaged temperature under native vegetation at 5cm. \cr
   TS10 \tab Temperature Under Native Vegetation at 10cm \tab degrees Celsius \tab 15-minute averaged temperature under native vegetation at 10cm. \cr
   TS25 \tab Temperature Under Native Vegetation at 25cm \tab degrees Celsius \tab 15-minute averaged temperature under native vegetation at 25cm. This variable is only available after and including December 1, 2013. \cr
   TS30 \tab Temperature Under Native Vegetation at 30cm \tab degrees Celsius \tab 15-minute averaged temperature under native vegetation at 30cm. This variable is only available prior to December 1, 2013. \cr
   TS45 \tab Temperature Under Native Vegetation at 45cm \tab degrees Celsius \tab 15-minute averaged temperature under native vegetation at 45cm. \cr
   TS60 \tab Temperature Under Native Vegetation at 60cm \tab degrees Celsius \tab 15-minute averaged temperature under native vegetation at 60cm. This variable is only available after and including December 1, 2013. \cr
   VW05 \tab Volumetric soil water Under Native Vegetation at 5cm \tab cm^3^ cm^-3^ \tab 5-minute averaged volumetric soil water under native vegetation at 5cm. \cr
   VW25 \tab Volumetric soil water Under Native Vegetation at 25cm \tab cm^3^ cm^-3^ \tab 5-minute averaged volumetric soil water under native vegetation at 25cm. \cr
   VW45 \tab Volumetric soil water Under Native Vegetation at 45cm \tab cm^3^ cm^-3^ \tab 5-minute averaged volumetric soil water under native vegetation at 45cm. \cr
   WDIR \tab Wind Direction \tab degrees \tab 5-minute averaged wind direction at 10m. \cr
   WDSD \tab Wind Direction Standard Deviation \tab degrees \tab Standard deviation of wind direction during the 5-minute interval. \cr
   WMAX \tab Maximum Wind Speed \tab meters per second \tab Highest 3-second wind speed at 10m sample. \cr
   WS2M \tab 2m Wind Speed \tab meters per second \tab 5-minute averaged wind speed at 2m \cr
   WSPD \tab Wind Speed \tab meters per second \tab 5-minute averaged wind speed at 10m. \cr
   WSSD \tab Wind Speed Standard Deviation \tab meters per second \tab Standard deviation of wind speed during the 5-minute interval. \cr
   WVEC \tab Wind Vector \tab meters per second \tab 5-minute averaged wind velocity (speed and direction accounted for) at 10m. \cr
}
}
\description{
Retrieves data from the Oklahoma Mesonet for
 a given set of station identifiers and date range
}
\examples{

\dontshow{
  mesonet_cache_dir <- mnet_test_cache(rds_files = TRUE)
  previous_options <- options(.mesonet_cache = mesonet_cache_dir)
}

mnet_retrieve(stid = "ACME",
                 start_date = "1994-01-02",
                 end_date = "1994-01-03")

\dontshow{
  unlink(mesonet_cache_dir, recursive = TRUE)
  options(previous_options)
}

}
