% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplification.R
\name{get.mesh.2.5D}
\alias{get.mesh.2.5D}
\title{Get surface mesh from an object of class \code{RcppSimplification}.}
\usage{
get.mesh.2.5D(x, order = 1)
}
\arguments{
\item{x}{An object of class \code{RcppSimplification}.}

\item{order}{Either '1' or '2'. It specifies whether each mesh triangle should be represented by \eqn{3} nodes (the triangle vertices) or by \eqn{6} nodes (the triangle vertices and midpoints of the triangle edges). These are respectively used for linear (\code{order} = 1) and quadratic (\code{order} = 2) Finite Elements. Default is \code{order} = 1.}
}
\value{
A \code{mesh.2.5D} object, endowed with the following attributes:
				\itemize{
					\item \code{nnodes}: number of nodes in the mesh;
					\item \code{nodes}: \code{nnodes}-by-3 matrix collecting the coordinates of each vertex;
					\item \code{ntriangles}: number of triangles in the mesh;
					\item \code{triangles}: a \code{ntriangles}-by-3 (when \code{order} = 1) or \code{ntriangles}-by-6 (when \code{order} = 2) matrix. It specifies the triangles giving the row indices in \code{nodes} of the triangles vertices and (when \code{order} = 2) also of the triangles edges midpoints;
					\item \code{order}: either '1' or '2'. It specifies whether each mesh triangle should be represented by \eqn{3} nodes (the triangle vertices) or by \eqn{6} nodes (the triangle vertices and midpoints of the triangle edges). These are respectively used for linear (\code{order} = 1) and quadratic (\code{order} = 2) Finite Elements. Default is \code{order} = 1.
				}
}
\description{
Extract the mesh from an object of class \code{RcppSimplification}. The mesh is returned as an instance of class \code{mesh.2.5D}. The order of the Finite Elements is compliant with the input parameter \code{order}.
}
\seealso{
\code{\link{simplify.mesh.2.5D}}
}
