% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{memo}
\alias{memo}
\title{Memoize a function.}
\usage{
memo(fn, cache = lru_cache(5000), key = hybrid_key, ...)
}
\arguments{
\item{fn}{A function to wrap. It should be a pure function (i.e. it should
not cause side effects, and should not depend on any variables that may
change.) It should not be a nonstandard-evaluating function. All arguments
will be forced by the wrapper.}

\item{cache}{A cache to use. Defaults to a new instance of
\code{\link{lru_cache}}.  Caches may be shared between memoized functions.}

\item{key}{A hashing strategy. The default "\code{\link{hybrid_key}}"
first checks for pointer equivalence and then falls back to using a
hash of the arguments. `pointer_key` uses just pointer equivalence,
and `digest_key` always performs a hash.}

\item{...}{Further arguments passed on to key.}
}
\description{
Memoize a function.
}
