% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{alc}
\alias{alc}
\title{Average local clustering (alc) coefficient}
\usage{
alc(adj, types = "uncorrected", weights = NULL, mode = "undirected")
}
\arguments{
\item{adj}{numeric matrix representing the adjacency matrix.}

\item{types}{character. Either \code{"uncorrected"} or \code{"corrected"}, or
a vector containing both.}

\item{weights}{numeric vector of edge weights. Optional.}

\item{mode}{character, either \code{"directed"} or \code{"undirected"},
specifying whether the network should be interepeted as directed
or undirected. Defaults to \code{"undirected"}.}
}
\value{
the corrected local clustering coefficient and/or
the uncorrected clustering coefficient.
}
\description{
Computes the uncorrected or corrected average local clustering coffiecient.
}
\details{
The uncorrected clustering coefficent is computed according to Watts &
Strogatz (1998). The corrected clustering coefficient normalizes the
uncorrected one by the \code{average degree / n nodes}, i.e., the expected
average local clustering for an Erdös-Renyi random graph.
}
\examples{

# get fluency data
data(animal_fluency)

# edge lists of fluency graphs
edge_list = threshold_graph(animal_fluency)

# get adjacency matrices
adj = edg_to_adj(edge_list)

# get local average clustering coefficient
alc(adj)

# get corrected local average clustering coefficient
alc(adj, types = 'corrected')

}
