% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memmodel.R
\name{memmodel}
\alias{memmodel}
\alias{summary.flu,plot.flu,print.flu}
\title{Methods for influenza modelization}
\usage{
memmodel(i.data, i.seasons = 10, i.type.threshold = 5,
  i.level.threshold = 0.95, i.tails.threshold = 1, i.type.intensity = 6,
  i.level.intensity = c(0.4, 0.9, 0.975), i.tails.intensity = 1,
  i.type.curve = 2, i.level.curve = 0.95, i.type.other = 3,
  i.level.other = 0.95, i.method = 2, i.param = 2.8, i.n.max = -1,
  i.type.boot = "norm", i.iter.boot = 10000)
}
\arguments{
\item{i.data}{Data frame of input data.}

\item{i.seasons}{Maximum number of seasons to use.}

\item{i.type.threshold}{Type of confidence interval to calculate the threshold.}

\item{i.level.threshold}{Level of confidence interval to calculate the threshold.}

\item{i.tails.threshold}{Tails for the confidence interval to calculate the threshold.}

\item{i.type.intensity}{Type of confidence interval to calculate the intensity thresholds.}

\item{i.level.intensity}{Levels of confidence interval to calculate the intensity thresholds.}

\item{i.tails.intensity}{Tails for the confidence interval to calculate the threshold.}

\item{i.type.curve}{Type of confidence interval to calculate the modelled curve.}

\item{i.level.curve}{Level of confidence interval to calculate the modelled curve.}

\item{i.type.other}{Type of confidence interval to calculate length, start and percentages.}

\item{i.level.other}{Level of confidence interval to calculate length, start and percentages.}

\item{i.method}{Method to calculate the optimal timing of the epidemic.}

\item{i.param}{Parameter to calculate the optimal timing of the epidemic.}

\item{i.n.max}{Number of pre-epidemic values used to calculate the threshold.}

\item{i.type.boot}{Type of bootstrap technique.}

\item{i.iter.boot}{Number of bootstrap iterations.}
}
\value{
\code{memmodel} returns an object of class \code{mem}.
An object of class \code{mem} is a list containing at least the following components:
  \item{i.data }{input data}
  \item{pre.post.intervals }{Pre/post confidence intervals (Threhold is the upper limit
  of the confidence interval).}
  \item{ci.length }{Mean epidemic length confidence interval.}
  \item{ci.percent }{Mean covered percentage confidence interval.}
  \item{mean.length }{Mean length.}
  \item{moving.epidemics }{Moving epidemic rates.}
  \item{mean.start }{Mean epidemic start.}
  \item{epi.intervals }{Epidemic levels of intensity.}
  \item{typ.curve }{Typical epidemic curve.}
  \item{n.max }{Effective number of pre epidemic values.}
}
\description{
Function \code{memmodel} is used to calculate the threshold for influenza epidemic using historical
records (surveillance rates).\cr
The method to calculate the threshold is described in the Moving Epidemics Method (MEM) used to
monitor influenza activity in a weekly surveillance system.
}
\details{
Input data is a data frame containing rates that represent historical influenza surveillance
data. It can start and end at any given week (tipically at week 40th), and rates can be
expressed as per 100,000 inhabitants (or per consultations, if population is not
available) or any other scale.\cr
Parameters \code{i.type}, \code{i.type.threshold} and \code{i.type.curve} defines how to
calculate confidence intervals along the process.\cr
\code{i.type.curve} is used for calculating the typical influenza curve,
\code{i.type.threshold} is used to calculate the pre and post epidemic threshold and
\code{i.type} is used for any other confidende interval used in the method.\cr
All three parameters must be a number between \code{1} and \code{6}:\cr
\tabular{rlll}{
\tab \code{1} \tab Arithmetic mean and mean confidence interval.\cr
\tab \code{2} \tab Geometric mean and mean confidence interval.\cr
\tab \code{3} \tab Median and the KC Method to calculate its confidence interval.\cr
\tab \code{4} \tab Median and bootstrap confidence interval.\cr
\tab \code{5} \tab Arithmetic mean and point confidence interval (standard deviations).\cr
\tab \code{6} \tab Geometric mean and point confidence interval (standard deviations).\cr
}
Option \code{4} uses two more parameters: \code{i.type.boot} indicates which bootstrap
method to use. The values are the same of those of the \code{\link{boot.ci}} function.
Parameter \code{i.iter.boot} indicates the number of bootstrap samples to use. See
\code{\link{boot}} for more information about this topic.\cr
Parameters \code{i.level}, \code{i.level.threshold} and \code{i.level.curve} indicates,
respectively, the level of the confidence intervals described above.\cr
The \code{i.n.max} parameter indicates how many pre epidemic values to use to calculate
the threshold. A value of -1 indicates the program to use an appropiate number of points
depending on the number of seasons provided as input. \code{i.tails} tells the program
to use {1} or {2} tailed confidence intervals when calculating the threshold (1 is
recommended).\cr
Parameters \code{i.method} and \code{i.param} indicates how to find the optimal timing
of the epidemics. See \code{\link{memtiming}} for details on the values this parameters
can have.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Finds the timing of the first season: 2001/2002
epi<-memmodel(flucyl)
print(epi)
summary(epi)
plot(epi)

}
\references{
Vega Alonso, Tomas, Jose E Lozano Alonso, Raul Ortiz de Lejarazu, and Marisol Gutierrez Perez. 2004.
Modelling Influenza Epidemic: Can We Detect the Beginning and Predict the Intensity and Duration?
International Congress Series, Options for the Control of Influenza V. Proceedings of the International
Conference on Options for the Control of Influenza V, 1263 (June): 281-83. doi:10.1016/j.ics.2004.02.121.\cr
Vega, Tomas, Jose Eugenio Lozano, Tamara Meerhoff, Rene Snacken, Joshua Mott, Raul Ortiz de Lejarazu, and
Baltazar Nunes. 2013. Influenza Surveillance in Europe: Establishing Epidemic Thresholds by the Moving
Epidemic Method. Influenza and Other Respiratory Viruses 7 (4): 546-58. doi:10.1111/j.1750-2659.2012.00422.x.\cr
Vega, Tomas, Jose E. Lozano, Tamara Meerhoff, Rene Snacken, Julien Beaute, Pernille Jorgensen, Raul Ortiz
de Lejarazu, et al. 2015. Influenza Surveillance in Europe: Comparing Intensity Levels Calculated Using
the Moving Epidemic Method. Influenza and Other Respiratory Viruses 9 (5): 234-46. doi:10.1111/irv.12330.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
