% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_table.R
\name{melt_table}
\alias{melt_table}
\alias{melt_table2}
\title{Return melted data for each token in a whitespace-separated file}
\usage{
melt_table(
  file,
  locale = default_locale(),
  na = "NA",
  skip = 0,
  n_max = Inf,
  guess_max = min(n_max, 1000),
  progress = show_progress(),
  comment = "",
  skip_empty_rows = FALSE
)

melt_table2(
  file,
  locale = default_locale(),
  na = "NA",
  skip = 0,
  n_max = Inf,
  progress = show_progress(),
  comment = "",
  skip_empty_rows = FALSE
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[readr:clipboard]{clipboard()}} will read from the system clipboard.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[readr:locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{guess_max}{Maximum number of records to use for guessing column types.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}
}
\value{
A \code{\link[=tibble]{tibble()}} of four columns:
\itemize{
\item \code{row}, the row that the token comes from in the original file
\item \code{col}, the column that the token comes from in the original file
\item \code{data_type}, the data type of the token, e.g. \code{"integer"}, \code{"character"},
\code{"date"}, guessed in a similar way to the \code{guess_parser()} function.
\item \code{value}, the token itself as a character string, unchanged from its
representation in the original file.
}

If there are parsing problems, a warning tells you
how many, and you can retrieve the details with \code{\link[=problems]{problems()}}.
}
\description{
For certain non-rectangular data formats, it can be useful to parse the data
into a melted format where each row represents a single token.

\code{melt_table()} and \code{melt_table2()} are designed to read the type of textual
data where each column is separated by one (or more) columns of space.

\code{melt_table2()} allows any number of whitespace characters between columns,
and the lines can be of different lengths.

\code{melt_table()} is more strict, each line must be the same length,
and each field is in the same position in every line. It first finds empty
columns and then parses like a fixed width file.
}
\examples{
# One corner from http://www.masseyratings.com/cf/compare.htm
massey <- meltr_example("massey-rating.txt")
cat(readLines(massey))
melt_table(massey)

# Sample of 1978 fuel economy data from
# http://www.fueleconomy.gov/feg/epadata/78data.zip
epa <- meltr_example("epa78.txt")
writeLines(readLines(epa))
melt_table(epa)
}
\seealso{
\code{\link[=melt_fwf]{melt_fwf()}} to melt fixed width files where each column
is not separated by whitespace. \code{melt_fwf()} is also useful for reading
tabular data with non-standard formatting.  \code{\link[readr:read_table]{readr::read_table()}} is the
conventional way to read tabular data from whitespace-separated files.
}
