% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pos_names.R
\name{pos_names}
\alias{pos_names}
\title{Provide pre-extracted names for Provider of Service file, years 2000-2010}
\usage{
pos_names(year)
}
\arguments{
\item{year}{A year in the range 2000-2010}
}
\value{
A list of names for the POS dataset in the year specified, in the 
  order that the raw data lists them
  
  This function returns the results of running \code{pos_names_extract} on 
  the layout and raw data files for the chosen year. For years 2000-2010, the
  raw data had unhelpful, generic, sequentially numbered variable names.
  These can be calculated fresh by calling \code{pos_names_extract} on the
  imported dataframe and its corresponding layout .txt file. Alternately,
  this function returns the names compiled by that function for years
  2000-2010, saving the user a step.
}
\description{
Provide pre-extracted names for Provider of Service file, years 2000-2010
}
\examples{

# get the list
pos_names(2005)
pos_names(2010)

}

