% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediateP.R
\name{mediate_contY_contM}
\alias{mediate_contY_contM}
\title{Mediation analysis function for continuous outcome and mediator}
\usage{
mediate_contY_contM(
  data,
  outcome = "Y",
  mediator = "M",
  exposure = "X",
  covariateY = c("X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8"),
  covariateM = c("X1", "X2", "X3", "X4", "X5", "X6", "X7"),
  x0 = 0,
  x1 = 1
)
}
\arguments{
\item{data}{A dataset.}

\item{outcome}{The outcome variable.}

\item{mediator}{The mediator variable.}

\item{exposure}{The exposure variable.}

\item{covariateY}{A vector of confounders in the outcome regression.}

\item{covariateM}{A vector of confounders in the mediator regression.}

\item{x0}{The baseline exposure level.}

\item{x1}{The new exposure level.}
}
\value{
A list containing NIE, NDE and MP point and interval estimates.
}
\description{
Mediation analysis function for continuous outcome and mediator
}
