% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soil_retentionCurvePlot.R
\name{soil_retentionCurvePlot}
\alias{soil_retentionCurvePlot}
\alias{soil_conductivityCurvePlot}
\title{Soil water retention and conductivity plots}
\usage{
soil_retentionCurvePlot(
  soil,
  model = "SX",
  layer = 1,
  psi = seq(0, -6, by = -0.01),
  relative = TRUE,
  to = "SAT"
)

soil_conductivityCurvePlot(
  soil,
  model = "SX",
  layer = 1,
  psi = seq(0, -6, by = -0.01),
  relative = TRUE,
  to = "SAT",
  log = TRUE,
  mmol = TRUE
)
}
\arguments{
\item{soil}{Initialized soil object (returned by function \code{\link{soil}}).}

\item{model}{model Either 'SX' or 'VG' for Saxton's or Van Genuchten's water retention models; or 'both' to plot both retention models.}

\item{layer}{Soil layer to be plotted.}

\item{psi}{A numeric vector specifying a sequence of water potential values.}

\item{relative}{Boolean flag to indicate that retention curve should be relative to field capacity or saturation.}

\item{to}{Either 'SAT' (saturation) or 'FC' (field capacity).}

\item{log}{Boolean to display the y-axis in logarithm units}

\item{mmol}{Boolean flag to indicate that saturated conductivity units should be returned in mmol/m/s/MPa. If \code{mmol = FALSE} then units are cm/day.}
}
\value{
An object of class ggplot.
}
\description{
Functions to display water retention curves and conductivity curves.
}
\details{
\itemize{
\item{\code{soil_retentionCurvePlot()} allows plotting the water retention curve of a given soil layer.}
\item{\code{soil_conductivityCurvePlot()} allows plotting the conductivity curve of a given soil layer.}
}
}
\seealso{
\code{\link{soil_texture}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
