% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{knn_meanShift}
\alias{knn_meanShift}
\title{K-d tree based k nearest neighbor search}
\usage{
knn_meanShift(points, trainData, k = min(5, NROW(trainData)), weight,
  leafSize = 40, maxDist = Inf)
}
\arguments{
\item{points}{n vectors stored in an n by p matrix.  k nearest neighbors are
found for each vector.}

\item{trainData}{A matrix or vector of potential nearest neighbors.}

\item{k}{A scalar indicating the number neighbors to find.}

\item{weight}{A scalar or vector of length equal to the number of columns of 
\code{trainData}.   This value is used as the diagonal elements for the 
inverse covariance matrix of the Mahalanobis distance.}

\item{leafSize}{A scalar used to specify the number of points to store in the 
leaf nodes.}

\item{maxDist}{A vector specifying the maximum value of the Mahalanobis that
will be considered.}
}
\value{
A list is returned containing two items: \code{neighbors}, an n by k
  matrix of k indexes for each of the n vectors in \code{points}, corresponding to 
  the nearest neighbors in \code{trainData}.  \code{value}, a matrix of scalars 
  containing the k distances between the neighbors found in \code{trainData} 
  and \code{points}.
}
\description{
\code{knn_meanShift} performs a search for the k nearest neighbors of a single 
point, where nearest is determined by the Mahalanobis distance.  This search
is performed through a k-d tree.
}
\examples{
x <- matrix(runif(20),10,2)
neighbors <- knn_meanShift(c(0,0),x)
}
