% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spikelist_text.R
\name{read_spikelist_text}
\alias{read_spikelist_text}
\title{Construct an MEA object by importing from text files.}
\usage{
read_spikelist_text(spike_text_file, channel_text_file, chem_info, array,
  div = NULL)
}
\arguments{
\item{spike_text_file}{CSV with Spike time information}

\item{channel_text_file}{CSV with information regarding MEA layout}

\item{chem_info}{Optional chemical information (currently unused)}

\item{array}{Name of array}

\item{div}{Age of the recording (days in vitro)}
}
\value{
S the MEA object
}
\description{
Construct an MEA object by importing from text files.
}
\details{
This function can be used to read in spike times from text files.
}
\examples{
\donttest{
demas_platelayout = list(n_well = 6,
                        wells = paste0("w", 1:6),
                        n_well_r = 2,
                        n_well_c = 3,
                        layout = c(3, 2),
                        n_elec_r = 8,
                        n_elec_c = 8,
                        xlim = c(-100, 7200),
                        ylim = c(0, 6000),
                        spacing = 200,
                        corr_breaks = 0
                        )
add_plateinfo("demas-6well", demas_platelayout)
times = system.file("extdata/textreader/demas.times", package="meaRtools")
pos = system.file("extdata/textreader/demas.pos", package="meaRtools")
s = read_spikelist_text(times, pos, array="demas-6well")
meaRtools:::.plot_mealayout(s$layout, use_names = TRUE, cex=0.3)
}
}
\author{
Stephen Eglen
}
