% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/grt_base.R
\name{GOF}
\alias{GOF}
\title{Conduct goodness of fit tests}
\usage{
GOF(grtMod, teststat = "X2", observed = NULL)
}
\arguments{
\item{grtMod}{a \code{grt} object}

\item{teststat}{a string indicating which statistic to use in the test.
May be one of the following:
\itemize{
\item{'X2'}{for a chi-squared test}
\item{'G2'}{for a likelihood-ratio G-test}
\item{'AIC'}{for Akaike information criterion score}
\item{'AIC.c'}{for the AIC with finite sample size correction}
\item{'BIC'}{for Bayesian information criterion score}}}

\item{observed}{optional, to provide a matrix of observed frequencies if no fit conducted.}
}
\description{
Includes a number of common goodness of fit measures to compare different GRT models.
}
\examples{
data(thomas01a)
fit1 <- fit.grt(thomas01a)
fit2 <- fit.grt(thomas01a, PI = 'same_rho')

# Take the model with the lower AIC
GOF(fit1, teststat = 'AIC')
GOF(fit2, teststat = 'AIC')
}

