% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCMComparisonSummaryDF.R
\name{makeCMComparisonSummaryDF}
\alias{makeCMComparisonSummaryDF}
\title{Make CM Comparison Summary DF}
\usage{
makeCMComparisonSummaryDF(cms, model_description_df)
}
\arguments{
\item{cms}{List of similarity matrices of common size.}

\item{model_description_df}{A data.frame with as many rows as ``cms`` has
entries with a common ordering. Each row is expected to contain the
width/number of chains used in constructing the corresponding consensus
matrix and the depth/iteration from each chain that is used. The column names
should be ``Depth`` and ``Width``.}
}
\value{
A data frame of the mean absolute difference between consecutive 
ensembles from the ``model_description_df`` input.
}
\description{
Converts a list of consensus matrices into a long data.frame
ready for ggplot2. The matrices are given a common ordering defined by the
list entry in index ``matrix_setting_order``, this is the ``x`` and ``y``
entry in the output and is used in the ``ggplot2`` geom, ``geom_tile``, as
the ``x`` and ``y`` aesthetics.  The description of the ensembles generating
the matrices is given in ``model_description_df`` and is used to annotate the
matrices.
}
\examples{
\donttest{
model_description_df <- data.frame(
  "Depth" = rep(c(100, 500, 1000), 3),
  "Width" = c(rep(50, 3), rep(100, 3), rep(200, 3))
)
n_models <- nrow(model_description_df)
cms <- vector("list", n_models)
for (ii in seq(1, n_models)) {
  cms[[ii]] <- makeSimilarityMat(mcmc[[ii]]$allocations)
}
mean_abs_diff_df <- makeCMComparisonSummaryDF(cms, model_description_df)
}
}
