/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import multidendrograms.core.definitions.SymmetricMatrix;
import multidendrograms.types.ProximityType;
import multidendrograms.utils.NumberUtils;

public class ConnectedGraph {
    private SymmetricMatrix proxiMatrix;
    private String[] labels;
    private ProximityType proxiType;
    private int precision;
    private SymmetricMatrix ultraMatrix;

    public ConnectedGraph(SymmetricMatrix symmetricMatrix, String[] stringArray, ProximityType proximityType, int n, SymmetricMatrix symmetricMatrix2) {
        this.proxiMatrix = symmetricMatrix;
        this.labels = stringArray;
        this.proxiType = proximityType;
        this.precision = n;
        this.ultraMatrix = symmetricMatrix2;
    }

    public void saveAsNet(String string) throws IOException {
        int n;
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("*Vertices " + this.labels.length);
        for (n = 0; n < this.labels.length; ++n) {
            printWriter.println(n + 1 + " " + this.labels[n]);
        }
        n = this.proxiType.equals((Object)ProximityType.DISTANCE) ? 1 : 0;
        printWriter.println("*Edges");
        for (int i = 0; i < this.proxiMatrix.numberOfRows(); ++i) {
            for (int j = i + 1; j < this.proxiMatrix.numberOfRows(); ++j) {
                double d = this.proxiMatrix.getElement(i, j);
                double d2 = this.ultraMatrix.getElement(i, j);
                if (!(n != 0 && d <= d2) && (n != 0 || !(d >= d2))) continue;
                printWriter.println(i + 1 + " " + (j + 1) + " " + NumberUtils.format(d, this.precision));
            }
        }
        printWriter.close();
    }
}

