/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.initial;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import multidendrograms.direct.DirectClustering;
import multidendrograms.errors.MethodError;
import multidendrograms.forms.PrincipalDesk;
import multidendrograms.forms.children.UpgradeBox;
import multidendrograms.initial.InitialProperties;
import multidendrograms.initial.Language;
import multidendrograms.initial.LogManager;
import multidendrograms.initial.MainProperties;
import multidendrograms.initial.MethodName;
import multidendrograms.types.BandHeight;
import multidendrograms.types.MethodType;
import multidendrograms.types.OriginType;
import multidendrograms.types.ProximityType;
import multidendrograms.utils.VersionNumber;

public class Main {
    public static final String PROGRAM = "MultiDendrograms";
    public static final String VERSION = "5.0.3";
    public static final String VERSION_SHORT = "5.0";
    public static final String AUTHORS = "Sergio Gomez, Alberto Fernandez, Justo Montiel, David Torres";
    public static final String ADVISORS = "Sergio Gomez, Alberto Fernandez";
    public static final String AFFILIATION = "Universitat Rovira i Virgili, Tarragona (Spain)";
    public static final String HOMEPAGE_URL = "http://deim.urv.cat/~sergio.gomez/multidendrograms.php";
    public static final String LICENSE_URL = "http://www.gnu.org/licenses/lgpl.html";
    public static final String MANUAL_URL = "http://deim.urv.cat/~sergio.gomez/download.php?f=multidendrograms-5.0-manual.pdf";
    public static final String LAST_VERSION_URL = "http://deim.urv.cat/~sergio.gomez/download.php?f=multidendrograms-last.txt";
    public static final String LOGO_IMAGE = "img/logo.png";
    private static final LogManager.LogType LOG_XML = LogManager.LogType.XML;
    private static final String LOG_FILE = "logs/md_log.xml";
    private static final String CONFIGURATION_FILE = "ini/md.ini";
    private static final int TOOLTIP_DISMISS_DELAY = 20000;
    private static VersionNumber vn;
    private static VersionNumber vnWeb;
    private static Boolean isDirect;

    public Main() {
        PrincipalDesk principalDesk = new PrincipalDesk(PROGRAM);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = principalDesk.getSize();
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        principalDesk.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        principalDesk.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        OriginType originType;
        boolean bl;
        double d;
        MethodType methodType;
        int n;
        ProximityType proximityType;
        String string;
        block52: {
            block51: {
                Level level = Level.WARNING;
                string = "";
                proximityType = ProximityType.DISTANCE;
                n = Integer.MIN_VALUE;
                methodType = MethodType.ARITHMETIC_LINKAGE;
                d = 0.0;
                bl = false;
                originType = OriginType.UNIFORM_ORIGIN;
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i].toUpperCase();
                    if (((String)object).equals("-H") || ((String)object).equals("-HELP")) {
                        Main.showSyntax();
                        return;
                    }
                    if (((String)object).equals("-LOGLEVEL")) {
                        try {
                            object = stringArray[++i].toUpperCase();
                            if (((String)object).equals("OFF")) {
                                level = Level.OFF;
                                continue;
                            }
                            if (((String)object).equals("SEVERE")) {
                                level = Level.SEVERE;
                                continue;
                            }
                            if (((String)object).equals("WARNING")) {
                                level = Level.WARNING;
                                continue;
                            }
                            if (((String)object).equals("INFO")) {
                                level = Level.INFO;
                                continue;
                            }
                            if (((String)object).equals("CONFIG")) {
                                level = Level.CONFIG;
                                continue;
                            }
                            if (((String)object).equals("FINE")) {
                                level = Level.FINE;
                                continue;
                            }
                            if (((String)object).equals("FINER")) {
                                level = Level.FINER;
                                continue;
                            }
                            if (((String)object).equals("FINEST")) {
                                level = Level.FINEST;
                                continue;
                            }
                            if (((String)object).equals("ALL")) {
                                level = Level.ALL;
                                continue;
                            }
                            System.out.println("Error: unknown log level '" + stringArray[i] + "'");
                            Main.showSyntax();
                            return;
                        }
                        catch (Exception exception) {
                            Main.showSyntax();
                            return;
                        }
                    }
                    if (((String)object).equals("-DIRECT")) {
                        try {
                            string = stringArray[++i];
                            object = stringArray[++i].toUpperCase();
                            if (((String)object).equals("D") || ((String)object).equals("DIST") || ((String)object).equals("DISTANCE") || ((String)object).equals("DISTANCES")) {
                                proximityType = ProximityType.DISTANCE;
                            } else if (((String)object).equals("S") || ((String)object).equals("SIM") || ((String)object).equals("SIMILARITY") || ((String)object).equals("SIMILARITIES")) {
                                proximityType = ProximityType.SIMILARITY;
                            } else {
                                System.out.println("Error: unknown proximity type '" + stringArray[i] + "'");
                                Main.showSyntax();
                                return;
                            }
                            ++i;
                            try {
                                n = Integer.parseInt(stringArray[i]);
                                ++i;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            try {
                                methodType = MethodName.toMethodType(stringArray[i]);
                            }
                            catch (MethodError methodError) {
                                System.out.println("Error: unknown method name '" + stringArray[i] + "'");
                                Main.showSyntax();
                                return;
                            }
                            if (++i < stringArray.length) {
                                try {
                                    d = Double.parseDouble(stringArray[i]);
                                    if (d < -1.0 || 1.0 < d) {
                                        System.out.println(Language.getLabel(68));
                                        Main.showSyntax();
                                        return;
                                    }
                                    ++i;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (i < stringArray.length) {
                                    object = stringArray[i].toUpperCase();
                                    if (((String)object).equals("W") || ((String)object).equals("WEIGHTED")) {
                                        bl = true;
                                        ++i;
                                    } else if (((String)object).equals("UW") || ((String)object).equals("UNWEIGHTED")) {
                                        bl = false;
                                        ++i;
                                    }
                                }
                                if (i < stringArray.length) {
                                    object = stringArray[i].toUpperCase();
                                    if (((String)object).equals("UO") || ((String)object).equals("UNIFORM_ORIGIN")) {
                                        originType = OriginType.UNIFORM_ORIGIN;
                                    } else if (((String)object).equals("NUO") || ((String)object).equals("NON_UNIFORM_ORIGIN")) {
                                        originType = OriginType.NON_UNIFORM_ORIGIN;
                                    } else {
                                        System.out.println("Error: unknown parameter '" + stringArray[i] + "'");
                                        Main.showSyntax();
                                        return;
                                    }
                                }
                            }
                            isDirect = true;
                            continue;
                        }
                        catch (Exception exception) {
                            Main.showSyntax();
                            return;
                        }
                    }
                    Main.showSyntax();
                    return;
                }
                new LogManager(LOG_FILE, LOG_XML);
                LogManager.LOG.setLevel(level);
                LogManager.LOG.fine("Start program");
                try {
                    new MainProperties(CONFIGURATION_FILE);
                    new InitialProperties();
                }
                catch (Exception exception) {
                    LogManager.LOG.severe(exception.getMessage());
                    if (isDirect.booleanValue()) break block51;
                    JOptionPane.showMessageDialog(null, exception.getMessage(), PROGRAM, 0);
                }
            }
            try {
                new Language(InitialProperties.getLanguage());
                LogManager.LOG.config("Language loaded: " + InitialProperties.getLanguage());
            }
            catch (Exception exception) {
                LogManager.LOG.warning("Loading default language");
                if (isDirect.booleanValue()) break block52;
                JOptionPane.showMessageDialog(null, exception.getMessage(), PROGRAM, 0);
            }
        }
        object = new Thread(){

            @Override
            public void run() {
                if (Main.hasUpgrade()) {
                    if (isDirect.booleanValue()) {
                        String string = Language.getLabel(129) + " " + Main.PROGRAM + " " + vnWeb.getVersion() + " " + Language.getLabel(130) + " " + Main.HOMEPAGE_URL;
                        System.out.println(string);
                        System.out.println("---");
                    } else {
                        UpgradeBox upgradeBox = new UpgradeBox(vn.getVersion(), vnWeb.getVersion());
                        upgradeBox.setVisible(true);
                    }
                }
            }
        };
        ((Thread)object).start();
        if (isDirect.booleanValue()) {
            try {
                DirectClustering directClustering = new DirectClustering(string, proximityType, n, methodType, d, bl, originType, BandHeight.BAND_BOTTOM);
                directClustering.printMeasures();
                directClustering.saveMeasures();
                directClustering.saveUltrametric();
                directClustering.saveAsTxt();
                directClustering.saveAsNewick();
                directClustering.saveAsJson();
            }
            catch (Exception exception) {
                String string2 = "Parameters: -direct " + string + " " + (Object)((Object)proximityType);
                if (n != Integer.MIN_VALUE) {
                    string2 = string2 + " " + n;
                }
                if (bl) {
                    string2 = string2 + " WEIGHTED";
                }
                string2 = string2 + " " + (Object)((Object)methodType);
                if (methodType.equals((Object)MethodType.VERSATILE_LINKAGE) || methodType.equals((Object)MethodType.BETA_FLEXIBLE)) {
                    string2 = string2 + " " + d;
                }
                System.out.println(string2);
                LogManager.LOG.severe(exception.getMessage());
            }
        } else {
            try {
                new Main();
            }
            catch (Exception exception) {
                LogManager.LOG.severe(exception.getMessage());
                JOptionPane.showMessageDialog(null, exception.getMessage(), PROGRAM, 0);
            }
        }
    }

    private static void showSyntax() {
        System.out.println("Usage: java -jar multidendrograms.jar [ options ]");
        System.out.println("");
        System.out.println("    -h | -help");
        System.out.println("        Syntax help");
        System.out.println("");
        System.out.println("    -loglevel  LEVEL");
        System.out.println("        Sets de verbosity level of the logger");
        System.out.println("        LEVEL     : verbosity level, one of");
        System.out.println("                      OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST, ALL");
        System.out.println("                      Default value for LEVEL: WARNING");
        System.out.println("");
        System.out.println("    -direct  FILE_NAME  PROX_TYPE  [ PRECISION ]  METHOD  [ METHOD_P ]  [ WEIGHTED ]  [ ORIGIN ]");
        System.out.println("        Direct calculation of the multidendrogram without graphic interface");
        System.out.println("        FILE_NAME : name of the data file");
        System.out.println("        PROX_TYPE : proximity type, one of");
        System.out.println("                      D, DIST, DISTANCE, DISTANCES");
        System.out.println("                      S, SIM, SIMILARITY, SIMILARITIES");
        System.out.println("        PRECISION : number of decimal significant digits, auto if missing value");
        System.out.println("        METHOD    : agglomeration type, one of");
        System.out.println("                      VL, VERSATILE_LINKAGE");
        System.out.println("                      SL, SINGLE_LINKAGE");
        System.out.println("                      CL, COMPLETE_LINKAGE");
        System.out.println("                      AL, ARITHMETIC_LINKAGE");
        System.out.println("                      GL, GEOMETRIC_LINKAGE");
        System.out.println("                      HL, HARMONIC_LINKAGE");
        System.out.println("                      CD, CENTROID");
        System.out.println("                      WD, WARD");
        System.out.println("                      BF, BETA_FLEXIBLE");
        System.out.println("        METHOD_P  : method parameter, between -1 and +1, necessary for");
        System.out.println("                      VL, VERSATILE_LINKAGE");
        System.out.println("                      BF, BETA_FLEXIBLE");
        System.out.println("                      Default value for METHOD_P: 0");
        System.out.println("        WEIGHTED  : weighted method, one of");
        System.out.println("                      W, WEIGHTED");
        System.out.println("                      UW, UNWEIGHTED");
        System.out.println("                      Default value for WEIGHTED: UNWEIGHTED");
        System.out.println("        ORIGIN    : origin type, one of");
        System.out.println("                      UO, UNIFORM_ORIGIN");
        System.out.println("                      NUO, NON_UNIFORM_ORIGIN");
        System.out.println("                      Default value for ORIGIN: UNIFORM_ORIGIN");
        System.out.println("");
        System.out.println("");
        System.out.println("Equivalences between clustering algorithms:");
        System.out.println("    Arithmetic Linkage Unweighted  = UPGMA = unweighted average");
        System.out.println("    Versatile Linkage (param  1.0) = Complete Linkage");
        System.out.println("    Versatile Linkage (param  0.1) = Arithmetic Linkage");
        System.out.println("    Versatile Linkage (param  0.0) = Geometric Linkage");
        System.out.println("    Versatile Linkage (param -0.1) = Harmonic Linkage");
        System.out.println("    Versatile Linkage (param -1.0) = Single Linkage");
        System.out.println("    Beta Flexible     (param  0.0) = Arithmetic Linkage");
        System.out.println("");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("    java -jar multidendrograms.jar");
        System.out.println("    java -jar multidendrograms.jar -loglevel OFF");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt DISTANCES 3 Complete_Linkage");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt D CL");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt D 3 CL");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt D 3 Versatile_Linkage +1");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt D 3 VL 0.1 W");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt D CL UO");
        System.out.println("    java -jar multidendrograms.jar -direct data.txt D 3 CL NUO");
    }

    private static boolean hasUpgrade() {
        boolean bl = false;
        try {
            URL uRL = new URL(LAST_VERSION_URL);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            vn = new VersionNumber(VERSION);
            vnWeb = new VersionNumber(string);
            if (vnWeb.newerThan(vn)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    static {
        isDirect = false;
    }
}

