/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.panels;

import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.core.definitions.SymmetricMatrix;
import multidendrograms.data.DataFile;
import multidendrograms.data.ExternalData;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.Formats;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.DendrogramPlot;
import multidendrograms.dendrogram.UltrametricMatrix;
import multidendrograms.direct.DirectClustering;
import multidendrograms.forms.DendrogramFrame;
import multidendrograms.forms.DendrogramParameters;
import multidendrograms.forms.PrincipalDesk;
import multidendrograms.forms.children.DendrogramPanel;
import multidendrograms.forms.panels.SettingsPanel;
import multidendrograms.forms.scrollabledesktop.DesktopConstants;
import multidendrograms.initial.Language;
import multidendrograms.types.BandHeight;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.MethodType;

public class LoadUpdatePanel
extends JPanel
implements ActionListener,
InternalFrameListener,
PropertyChangeListener,
DesktopConstants {
    private static final long serialVersionUID = 1L;
    private final PrincipalDesk principalDesk;
    protected LoadUpdatePanel luPanel;
    private String strLoad;
    private String strUpdate;
    private static JButton btnLoad;
    private static JButton btnUpdate;
    private static JTextField txtFileName;
    private JProgressBar progressBar;
    public static boolean buttonClicked;
    public static boolean precisionCorrect;
    public static boolean methodParameterCorrect;
    public static boolean axisMinCorrect;
    public static boolean axisMaxCorrect;
    public static boolean axisSeparationCorrect;
    public static boolean axisTicksCorrect;
    public static boolean axisDecimalsCorrect;
    private DendrogramFrame currentDendrogramFrame = null;
    private static DataFile dataFile;
    private ExternalData externalData;
    private HierarchicalClustering clustering = null;

    public LoadUpdatePanel(PrincipalDesk principalDesk) {
        this.principalDesk = principalDesk;
        this.luPanel = this;
        this.fillPanel();
        this.setVisible(true);
    }

    private void fillPanel() {
        this.setBorder(Formats.getFormattedTitledBorder(Language.getLabel(20)));
        this.strLoad = Language.getLabel(21);
        btnLoad = Formats.getFormattedBoldButton(this.strLoad);
        btnLoad.addActionListener(this);
        this.strUpdate = Language.getLabel(110);
        btnUpdate = Formats.getFormattedBoldButton(this.strUpdate);
        btnUpdate.addActionListener(this);
        btnUpdate.setEnabled(false);
        txtFileName = Formats.getFormattedTextField();
        txtFileName.addActionListener(this);
        txtFileName.setEditable(false);
        txtFileName.setHorizontalAlignment(2);
        LoadUpdatePanel.setFileName(Language.getLabel(112));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setBorderPainted(false);
        this.progressBar.setValue(0);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup().addComponent(btnLoad, 110, 110, 110).addGap(3, 3, 3).addComponent(btnUpdate, 110, 110, 110)).addGroup(GroupLayout.Alignment.CENTER, groupLayout.createSequentialGroup().addComponent(txtFileName, 223, 223, 223)).addGroup(GroupLayout.Alignment.CENTER, groupLayout.createSequentialGroup().addComponent(this.progressBar))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGap(6, 6, 6));
        groupLayout.linkSize(0, txtFileName, this.progressBar);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(btnLoad).addComponent(btnUpdate)).addGap(3, 3, 3).addComponent(txtFileName).addGap(3, 3, 3).addComponent(this.progressBar).addGap(1, 1, 1));
    }

    public static void enableUpdate() {
        if (precisionCorrect && methodParameterCorrect && axisMinCorrect && axisMaxCorrect && axisSeparationCorrect && axisTicksCorrect && axisDecimalsCorrect) {
            btnUpdate.setEnabled(true);
        } else {
            btnUpdate.setEnabled(false);
        }
    }

    public static String getFileName() {
        String string = "";
        if (dataFile != null) {
            string = dataFile.getName();
        }
        return string;
    }

    public static String getFileNameNoExt() {
        String string = "";
        if (dataFile != null) {
            string = dataFile.getNameNoExt();
        }
        return string;
    }

    public static void setFileName(String string) {
        txtFileName.setText(string);
        txtFileName.setCaretPosition(0);
        txtFileName.setToolTipText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block15: {
            String string = null;
            boolean bl = false;
            if (actionEvent.getActionCommand().equals(this.strLoad)) {
                buttonClicked = true;
                string = "Load";
                DataFile dataFile = LoadUpdatePanel.dataFile == null ? this.getDataFile() : this.getDataFile(LoadUpdatePanel.dataFile.getPath());
                if (dataFile == null) {
                    bl = false;
                } else {
                    LoadUpdatePanel.dataFile = dataFile;
                    bl = true;
                }
            } else if (actionEvent.getActionCommand().equals(this.strUpdate)) {
                buttonClicked = true;
                DendrogramParameters dendrogramParameters = this.currentDendrogramFrame.getDendrogramParameters();
                string = SettingsPanel.getProximityType() == dendrogramParameters.getProximityType() && SettingsPanel.getPrecision() == dendrogramParameters.getPrecision() && SettingsPanel.getMethod() == dendrogramParameters.getMethod() && SettingsPanel.getMethodParameter() == dendrogramParameters.getMethodParameter() && SettingsPanel.isWeighted() == dendrogramParameters.isWeighted() ? "Redraw" : "Reload";
                bl = true;
            }
            if (bl && (string.equals("Load") || string.equals("Reload"))) {
                try {
                    this.externalData = new ExternalData(dataFile);
                    SymmetricMatrix symmetricMatrix = this.externalData.getProximityMatrix();
                    MethodType methodType = SettingsPanel.getMethod();
                    if (symmetricMatrix.minimumValue() < 0.0 && (methodType.equals((Object)MethodType.VERSATILE_LINKAGE) || methodType.equals((Object)MethodType.GEOMETRIC_LINKAGE))) {
                        buttonClicked = false;
                        this.showError(Language.getLabel(80));
                        break block15;
                    }
                    if (string.equals("Load")) {
                        SettingsPanel.setPrecision(this.externalData.getPrecision());
                    }
                    this.clustering = null;
                    try {
                        this.clustering = DirectClustering.newClustering(methodType, symmetricMatrix, this.externalData.getNames(), SettingsPanel.getProximityType(), SettingsPanel.getPrecision(), SettingsPanel.isWeighted(), SettingsPanel.getMethodParameter());
                        this.progressBar.setBorderPainted(true);
                        this.progressBar.setString(null);
                        this.principalDesk.setCursor(Cursor.getPredefinedCursor(3));
                        MDComputation mDComputation = new MDComputation(string, this.externalData.getNumberOfElements());
                        mDComputation.addPropertyChangeListener(this);
                        mDComputation.execute();
                    }
                    catch (Exception exception) {
                        buttonClicked = false;
                        this.showError(exception.getMessage());
                    }
                }
                catch (Exception exception) {
                    buttonClicked = false;
                    this.showError(exception.getMessage());
                }
            } else if (bl && string.equals("Redraw")) {
                this.showCalls(string);
            } else {
                buttonClicked = false;
            }
        }
    }

    private void showCalls(String string) {
        if (string.equals("Reload") || string.equals("Redraw")) {
            this.currentDendrogramFrame.doDefaultCloseAction();
        }
        this.show(string, SettingsPanel.getMethod());
        this.currentDendrogramFrame.doDefaultCloseAction();
        this.show(string, SettingsPanel.getMethod());
        LoadUpdatePanel.setFileName(dataFile.getName());
        btnUpdate.setEnabled(true);
        buttonClicked = false;
    }

    private void show(String string, MethodType methodType) {
        try {
            boolean bl = !string.equals("Load");
            DendrogramFrame dendrogramFrame = this.principalDesk.createDendrogramFrame(bl, methodType);
            SettingsInfo settingsInfo = SettingsPanel.getSettingsInfo();
            Config config = new Config(settingsInfo);
            config.setDendrogramFrame(dendrogramFrame);
            config.setDataFile(dataFile);
            config.setHierarchicalClustering(this.clustering);
            config.setExternalData(this.externalData);
            if (!config.isDistance()) {
                if (config.getDendrogramOrientation().equals((Object)DendrogramOrientation.NORTH)) {
                    config.setDendrogramOrientation(DendrogramOrientation.SOUTH);
                } else if (config.getDendrogramOrientation().equals((Object)DendrogramOrientation.SOUTH)) {
                    config.setDendrogramOrientation(DendrogramOrientation.NORTH);
                } else if (config.getDendrogramOrientation().equals((Object)DendrogramOrientation.EAST)) {
                    config.setDendrogramOrientation(DendrogramOrientation.WEST);
                } else if (config.getDendrogramOrientation().equals((Object)DendrogramOrientation.WEST)) {
                    config.setDendrogramOrientation(DendrogramOrientation.EAST);
                }
            }
            DendrogramParameters dendrogramParameters = new DendrogramParameters(this.externalData, this.clustering);
            dendrogramFrame.setDendrogramParameters(dendrogramParameters);
            String string2 = dataFile.getName() + " - " + dendrogramFrame.getTitle();
            dendrogramFrame.setTitle(string2);
            dendrogramFrame.getAssociatedButton().setText(string2);
            dendrogramFrame.getAssociatedButton().setToolTipText(string2);
            DendrogramPanel dendrogramPanel = new DendrogramPanel(this.principalDesk);
            dendrogramFrame.add(dendrogramPanel);
            dendrogramFrame.setVisible(true);
            if (string.equals("Load") || string.equals("Reload")) {
                SettingsPanel.adjustValues(config);
            }
            this.principalDesk.setCurrentFrame(dendrogramFrame);
            DendrogramPlot dendrogramPlot = new DendrogramPlot(this.clustering.getRoot(), config);
            UltrametricMatrix ultrametricMatrix = new UltrametricMatrix(this.clustering.getRoot(), this.externalData.getNames(), settingsInfo.getOriginType(), BandHeight.BAND_BOTTOM);
            dendrogramParameters.setUltrametricMatrix(ultrametricMatrix);
            dendrogramPanel.setNodesList(dendrogramPlot.getNodesList());
            dendrogramPanel.setLinesList(dendrogramPlot.getLinesList());
            dendrogramPanel.setBandsList(dendrogramPlot.getBandsList());
            dendrogramPanel.setConfig(config);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showError(exception.getMessage());
        }
    }

    private DataFile getDataFile() {
        return this.getDataFile(System.getProperty("user.dir"));
    }

    private DataFile getDataFile(String string) {
        FileDialog fileDialog = new FileDialog((Frame)this.principalDesk, Language.getLabel(9), 0);
        DataFile dataFile = new DataFile();
        fileDialog.setDirectory(string);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            dataFile = null;
        } else {
            dataFile.setName(fileDialog.getFile());
            dataFile.setPath(fileDialog.getDirectory());
        }
        return dataFile;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(null, string, Language.getLabel(7), 0);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.currentDendrogramFrame = (DendrogramFrame)internalFrameEvent.getSource();
        btnUpdate.setEnabled(true);
        if (!buttonClicked) {
            this.principalDesk.setCurrentFrame(this.currentDendrogramFrame);
            DendrogramParameters dendrogramParameters = this.currentDendrogramFrame.getDendrogramParameters();
            this.externalData = dendrogramParameters.getExternalData();
            dataFile = this.externalData.getDataFile();
            LoadUpdatePanel.setFileName(dataFile.getName());
            this.clustering = dendrogramParameters.getHierarchicalClustering();
            SettingsPanel.setConfigPanel(dendrogramParameters);
        }
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        btnUpdate.setEnabled(false);
        LoadUpdatePanel.setFileName(Language.getLabel(112));
        if (!buttonClicked) {
            SettingsPanel.clearConfigPanel();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        if (this.principalDesk.getNumDendrogramFrames() < 50) {
            btnLoad.setEnabled(true);
        } else {
            btnLoad.setEnabled(false);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        if (this.principalDesk.getNumDendrogramFrames() < 50) {
            btnLoad.setEnabled(true);
        } else {
            btnLoad.setEnabled(false);
        }
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "progress") {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressBar.setValue(n);
        }
    }

    static {
        buttonClicked = false;
        precisionCorrect = false;
        methodParameterCorrect = false;
        axisMinCorrect = false;
        axisMaxCorrect = false;
        axisSeparationCorrect = false;
        axisTicksCorrect = false;
        axisDecimalsCorrect = false;
        dataFile = null;
    }

    class MDComputation
    extends SwingWorker<Void, Void> {
        private final String action;
        private final int nbElements;

        public MDComputation(String string, int n) {
            this.action = string;
            this.nbElements = n;
        }

        @Override
        public Void doInBackground() {
            int n = 0;
            this.setProgress(n);
            while (LoadUpdatePanel.this.clustering.numberOfRoots() > 1) {
                try {
                    LoadUpdatePanel.this.clustering.iteration();
                    n = 100 * (this.nbElements - LoadUpdatePanel.this.clustering.numberOfRoots()) / (this.nbElements - 1);
                    this.setProgress(n);
                }
                catch (Exception exception) {
                    LoadUpdatePanel.this.showError(exception.getMessage());
                }
            }
            return null;
        }

        @Override
        public void done() {
            LoadUpdatePanel.this.showCalls(this.action);
            LoadUpdatePanel.this.progressBar.setString("");
            LoadUpdatePanel.this.progressBar.setBorderPainted(false);
            LoadUpdatePanel.this.progressBar.setValue(0);
            LoadUpdatePanel.this.principalDesk.setCursor(null);
        }
    }
}

