/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.children;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.definitions.Config;
import multidendrograms.initial.InitialProperties;
import multidendrograms.initial.Language;
import multidendrograms.initial.MethodName;
import multidendrograms.utils.NumberUtils;

public class DendrogramTree
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Dendrogram branch;
    private final JTextArea txt;
    private final DefaultMutableTreeNode root;
    private final int precision;
    private String leafPrefix;
    private String leafPostfix;
    private String numPrefix;
    private String numPostfix;
    private String bandPrefix;
    private String bandPostfix;

    public DendrogramTree(Config config) throws Exception {
        int n;
        int n2;
        this.branch = config.getRoot();
        this.precision = config.getPrecision();
        this.root = new DefaultMutableTreeNode(Language.getLabel(62));
        JTree jTree = new JTree(this.root);
        jTree.setFont(InitialProperties.getFontLabel());
        this.txt = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTree, 22, 32);
        try {
            this.calculateHTMLTags();
            this.showBranch(this.branch, this.root);
            jTree.setExpandsSelectedPaths(true);
            this.txt.setEditable(false);
            this.add(jScrollPane);
            jTree.expandPath(new TreePath(this.root));
            n2 = jTree.getRowCount();
            for (n = 1; n2 - 1 >= n; ++n) {
                jTree.expandPath(jTree.getPathForRow(n));
                n2 = jTree.getRowCount();
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage() + "\n";
            string = string + Language.getLabel(78);
            throw new Exception(string);
        }
        n = InitialProperties.getWidthDendroWindow();
        n2 = InitialProperties.getHeightDendroWindow();
        this.txt.setSize(n, n2);
        this.setVisible(true);
        this.setTitle(config.getDataFile().getName() + " - " + MethodName.toName(config.getMethod()));
        this.setDefaultCloseOperation(2);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void showBranch(Dendrogram dendrogram, DefaultMutableTreeNode defaultMutableTreeNode) throws Exception {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (dendrogram.numberOfSubclusters() == 1) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("<html>" + this.leafPrefix + dendrogram.getLabel() + this.leafPostfix + "</html>");
        } else {
            double d;
            double d2 = dendrogram.getRootBottomHeight();
            if (d2 > (d = dendrogram.getRootTopHeight())) {
                double d3 = d2;
                d2 = d;
                d = d3;
            }
            d2 = MathUtils.round(d2, this.precision);
            d = MathUtils.round(d, this.precision);
            String string = NumberUtils.format(d2, this.precision);
            String string2 = NumberUtils.format(d, this.precision);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("<html>" + this.numPrefix + dendrogram.numberOfSubclusters() + this.numPostfix + " &nbsp;&nbsp; " + this.bandPrefix + " [" + string + ", " + string2 + "] " + this.bandPostfix + " &nbsp;&nbsp; " + this.numPrefix + " <i>" + dendrogram.numberOfLeaves() + "</i> " + this.numPostfix + "</html>");
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (dendrogram.numberOfSubclusters() > 1) {
            for (int i = 0; i < dendrogram.numberOfSubclusters(); ++i) {
                this.showBranch(dendrogram.getSubcluster(i), defaultMutableTreeNode2);
            }
        }
    }

    private void calculateHTMLTags() {
        Font font = InitialProperties.getFontTreeLeaf();
        Color color = InitialProperties.getColorTreeLeaf();
        if (font.isBold() && font.isItalic()) {
            this.leafPrefix = "<b color='" + this.colorToString(color) + "'><i>";
            this.leafPostfix = "</i></b>";
        } else if (font.isBold()) {
            this.leafPrefix = "<b color='" + this.colorToString(color) + "'>";
            this.leafPostfix = "</b>";
        } else if (font.isItalic()) {
            this.leafPrefix = "<i color='" + this.colorToString(color) + "'>";
            this.leafPostfix = "</i>";
        } else {
            this.leafPrefix = "<font color='" + this.colorToString(color) + "'>";
            this.leafPostfix = "</font>";
        }
        font = InitialProperties.getFontTreeNum();
        color = InitialProperties.getColorTreeNum();
        if (font.isBold() && font.isItalic()) {
            this.numPrefix = "<b color='" + this.colorToString(color) + "'><i>";
            this.numPostfix = "</i></b>";
        } else if (font.isBold()) {
            this.numPrefix = "<b color='" + this.colorToString(color) + "'>";
            this.numPostfix = "</b>";
        } else if (font.isItalic()) {
            this.numPrefix = "<i color='" + this.colorToString(color) + "'>";
            this.numPostfix = "</i>";
        } else {
            this.numPrefix = "<font color='" + this.colorToString(color) + "'>";
            this.numPostfix = "</font>";
        }
        font = InitialProperties.getFontTreeBand();
        color = InitialProperties.getColorTreeBand();
        if (font.isBold() && font.isItalic()) {
            this.bandPrefix = "<b color='" + this.colorToString(color) + "'><i>";
            this.bandPostfix = "</i></b>";
        } else if (font.isBold()) {
            this.bandPrefix = "<b color='" + this.colorToString(color) + "'>";
            this.bandPostfix = "</b>";
        } else if (font.isItalic()) {
            this.bandPrefix = "<i color='" + this.colorToString(color) + "'>";
            this.bandPostfix = "</i>";
        } else {
            this.bandPrefix = "<font color='" + this.colorToString(color) + "'>";
            this.bandPostfix = "</font>";
        }
    }

    private String colorToString(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }
}

