% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classres.R
\name{plotPredictions.classres}
\alias{plotPredictions.classres}
\title{Prediction plot for classification results}
\usage{
\method{plotPredictions}{classres}(
  obj,
  nc = seq_len(obj$nclasses),
  ncomp = obj$ncomp.selected,
  ylab = "",
  show.plot = TRUE,
  ...
)
}
\arguments{
\item{obj}{classification results (object of class \code{plsdares}, \code{simcamres}, etc.).}

\item{nc}{vector with classes to show predictions for.}

\item{ncomp}{model complexity (number of components) to make the plot for.}

\item{ylab}{label for y axis}

\item{show.plot}{logical, shall plot be created or just plot series object is needed}

\item{...}{most of the graphical parameters from \code{\link{mdaplotg}} or \code{\link{mdaplot}} function
can be used.}
}
\description{
Makes a plot with predicted class values for classification results.
}
\details{
See examples in description of \code{\link{plsdares}}, \code{\link{simcamres}}, etc.
}
