% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccfs.R
\name{ccfs.mcgf}
\alias{ccfs.mcgf}
\alias{ccfs.mcgf_rs}
\alias{ccfs<-}
\alias{add_ccfs}
\title{Extract, calculate, or assign cross-correlations for an \code{mcgf} or \code{mcgf_rs}
object}
\usage{
\method{ccfs}{mcgf}(x, lag_max, ncores = 1, replace = FALSE, ...)

\method{ccfs}{mcgf_rs}(x, lag_max, ncores = 1, replace = FALSE, ...)

ccfs(x) <- value

add_ccfs(x, lag_max, ncores = 1, ...)
}
\arguments{
\item{x}{An \code{mcgf} or \code{mcgf_rs} object.}

\item{lag_max}{Maximum lag at which to calculate the ccfs.}

\item{ncores}{Number of cpu cores used for computing. The \code{doParallel}
package is required when \code{ncores} > 1.}

\item{replace}{Logical; if TRUE, \code{acfs} are recalculated.}

\item{...}{Additional parameters or attributes. Not in use.}

\item{value}{Cross-correlations.}
}
\value{
\code{\link[=ccfs]{ccfs()}} returns (regime-switching) cross-correlations.
\code{\link[=add_ccfs]{add_ccfs()}} returns the same object with additional attributes of
(regime-switching) cross-correlations and (regime-switching) empirical
standard deviations.
}
\description{
Extract, calculate, or assign cross-correlations for an \code{mcgf} or \code{mcgf_rs}
object
}
\details{
For \code{mcgf} objects, \code{\link[=ccfs]{ccfs()}} computes cross-correlations for each time
lag. The output is an array of matrices where each matrix corresponds to the
cross-correlation for a time lag.

For \code{mcgf_rs} objects, \code{\link[=ccfs]{ccfs()}} computes regime-switching
cross-correlations for each time lag. The output is a list of array of
matrices where each array in the list corresponds to the cross-correlation
for a regime.

\code{\link{ccfs<-}} assigns \code{ccfs} to \code{x}.

\code{\link[=add_ccfs]{add_ccfs()}} adds \code{ccfs} and \code{sds} to \code{x}.
}
\examples{
# Calculate ccfs for 'sim1'
data(sim1)
sim1_mcgf <- mcgf(sim1$data, dists = sim1$dists)
ccfs(sim1_mcgf, lag_max = 5)

# To use multiple cores, use the `ncores` argument
ccfs(sim1_mcgf, lag_max = 5, ncores = 2)

# Add ccfs and sds to 'sim1_mcgf'
sim1_mcgf <- add_ccfs(sim1_mcgf, lag_max = 5)
print(sim1_mcgf, "ccfs")
print(sim1_mcgf, "sds")

# Calculate ccfs for 'sim2'
data(sim2)
sim2_mcgf <- mcgf_rs(sim2$data, dists = sim2$dists, label = sim2$label)
ccfs(sim2_mcgf, lag_max = 5)

# Add ccfs and sds to 'sim2_mcgf'
sim2_mcgf <- add_ccfs(sim2_mcgf, lag_max = 5)
print(sim2_mcgf, "ccfs")
print(sim2_mcgf, "sds")
}
\concept{functions related to acfs and ccfs}
