% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{EnsureBounds}
\alias{EnsureBounds}
\title{Altering vector of doubles to satisfy boundary constraints}
\usage{
EnsureBounds(doubles, mins, maxs)
}
\arguments{
\item{doubles}{A vector of doubles}

\item{mins}{A vector of lower bounds of decision variables}

\item{maxs}{A vector of upper bounds of decision variables}
}
\value{
Function directly modifies the argument \code{doubles} and does not return a result.
}
\description{
Byte based crossover and mutation operators can generate variables out of bounds of the decision variables. This function controls if variables are between their lower and upper bounds and if not, draws random numbers between these ranges. This function directly modifies the argument \code{doubles} and does not return a value.
}
\examples{
set.seed(1234)
x <- runif(10)
print(x)
# [1] 0.113703411 0.622299405 0.609274733 0.623379442 0.860915384 0.640310605
# [7] 0.009495756 0.232550506 0.666083758 0.514251141
EnsureBounds(x, mins=rep(0,10), maxs=rep(0.2,10))
print(x)
# [1] 0.113703411 0.138718258 0.108994967 0.056546717 0.184686697 0.058463168
# [7] 0.009495756 0.167459126 0.057244657 0.053364156
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\seealso{
byte_crossover

byte_mutation

mcga2
}

