% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccf1.R
\name{summary.mccf1}
\alias{summary.mccf1}
\title{Summarize the the performance of a binary classification using MCC-F1 metric and the best threshold}
\usage{
\method{summary}{mccf1}(object, digits, bins = 100, ...)
}
\arguments{
\item{object}{"mccf1" object resulting from the function mccf1}

\item{digits}{an integer, used for number formatting with \code{\link[base]{signif}}}

\item{bins}{an integer, will be used to divide the range of normalized MCC when calculating the MCC-F1 metric (default = 100)}

\item{...}{further arguments passed to and from methods}
}
\value{
a data.frame that shows the MCC-F1 metric (between 0 and 1) and the best threshold (between 0 and 1)
}
\description{
This function calculates the MCC-F1 metric and the best threshold for a binary classification.
}
\examples{
response <- c(rep(1, 1000), rep(0, 10000))
set.seed(2017)
predictor <- c(rbeta(300, 12, 2), rbeta(700, 3, 4), rbeta(10000, 2, 3))
\dontrun{summary(mccf1(response, predictor))}
# mccf1_metric best_threshold
#    0.3508904       0.786905
summary(mccf1(response, predictor), bins = 50)
# mccf1_metric best_threshold
#    0.3432971       0.786905
\dontrun{summary(mccf1(response, predictor), digits = 3)}
# mccf1_metric best_threshold
#    0.351          0.787
}
