% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuditorFitters.R
\name{AuditorFitter}
\alias{AuditorFitter}
\title{AuditorFitter Abstract Base Class}
\value{
\code{list} with items\cr
\itemize{
\item \code{corr}: pseudo-correlation between residuals and learner prediction.
\item \code{l}: the trained learner.
}
}
\description{
Defines an \code{AuditorFitter} abstract base class.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AuditorFitter-new}{\code{AuditorFitter$new()}}
\item \href{#method-AuditorFitter-fit_to_resid}{\code{AuditorFitter$fit_to_resid()}}
\item \href{#method-AuditorFitter-fit}{\code{AuditorFitter$fit()}}
\item \href{#method-AuditorFitter-clone}{\code{AuditorFitter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuditorFitter-new"></a>}}
\if{latex}{\out{\hypertarget{method-AuditorFitter-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{\link{AuditorFitter}}.
This is an abstract base class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuditorFitter$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuditorFitter-fit_to_resid"></a>}}
\if{latex}{\out{\hypertarget{method-AuditorFitter-fit_to_resid}{}}}
\subsection{Method \code{fit_to_resid()}}{
Fit to residuals.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuditorFitter$fit_to_resid(data, resid, mask)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{\link{data.table}}\cr
Features.}

\item{\code{resid}}{\code{\link{numeric}}\cr
Residuals (of same length as data).}

\item{\code{mask}}{\code{\link{integer}}\cr
Mask applied to the data. Only used for \code{SubgroupAuditorFitter}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuditorFitter-fit"></a>}}
\if{latex}{\out{\hypertarget{method-AuditorFitter-fit}{}}}
\subsection{Method \code{fit()}}{
Fit (mostly used internally, use \code{fit_to_resid}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuditorFitter$fit(data, resid, mask)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{\link{data.table}}\cr
Features.}

\item{\code{resid}}{\code{\link{numeric}}\cr
Residuals (of same length as data).}

\item{\code{mask}}{\code{\link{integer}}\cr
Mask applied to the data. Only used for \code{SubgroupAuditorFitter}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AuditorFitter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AuditorFitter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuditorFitter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
