% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dodecagon_maze.r
\name{dodecagon_maze}
\alias{dodecagon_maze}
\title{dodecagon_maze .}
\usage{
dodecagon_maze(depth, unit_len = 4L, clockwise = TRUE,
  start_from = c("midpoint", "corner"), method = c("hex_ring"),
  draw_boundary = FALSE, num_boundary_holes = 2, boundary_lines = TRUE,
  boundary_holes = NULL, boundary_hole_color = NULL,
  boundary_hole_locations = NULL, boundary_hole_arrows = FALSE,
  end_side = 1)
}
\arguments{
\item{depth}{the depth of recursion. This controls the side length.}

\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{clockwise}{whether to draw clockwise.}

\item{start_from}{whether to start from the midpoint of the first side
of a maze, or from the corner facing the first side.}

\item{method}{there are a few ways to recursively draw an decagon. 
The following values are acceptable:
\describe{
\item{hex_ring}{A regular hexagon maze in the center is drawn, with a 
ring of alternating squares and equilateral triangle mazes around it.}
}}

\item{draw_boundary}{a boolean indicating whether a final boundary shall be
drawn around the maze.}

\item{num_boundary_holes}{the number of boundary sides which should be
randomly selected to have holes. Note that the \code{boundary_holes}
parameter takes precedence.}

\item{boundary_lines}{indicates which of the sides of the maze
shall have drawn boundary lines. Can be a logical array indicating
which sides shall have lines, or a numeric array, giving the
index of sides that shall have lines.}

\item{boundary_holes}{an array indicating which of the boundary lines
have holes. If \code{NULL}, then boundary holes are randomly selected
by the \code{num_boundary_holes} parameter. If numeric, indicates
which sides of the maze shall have holes. If a boolean array, indicates
which of the sides shall have holes. These forms are recycled
if needed. See \code{\link{holey_path}}. Note that if no line
is drawn, no hole can be drawn either.}

\item{boundary_hole_color}{the color of boundary holes. A value of
\code{NULL} indicates no colored holes. See \code{\link{holey_path}}
for more details. Can be an array of colors, or colors and the 
value \code{'clear'}, which stands in for \code{NULL} to
indicate no filled hole to be drawn.}

\item{boundary_hole_locations}{the \sQuote{locations} of the boundary holes
within each boundary segment.
A value of \code{NULL} indicates the code may randomly choose, as is
the default.
May be a numeric array. A positive value up to the side length is
interpreted as the location to place the boundary hole.
A negative value is interpreted as counting down from the side
length plus 1. A value of zero corresponds to allowing the 
code to pick the location within a segment.
A value of \code{NA} may cause an error.}

\item{boundary_hole_arrows}{a boolean or boolean array indicating whether to draw
perpendicular double arrows at the boundary holes, as a visual guide. These
can be useful for locating the entry and exit points of a maze.}

\item{end_side}{the number of the side to end on. A value of
1 corresponds to the starting side, while higher numbers
correspond to the drawn side of the figure in the canonical order
(that is, the order induced by the \code{clockwise} parameter).}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Draw a regular dodecagon maze, with each side consisting of
of \eqn{2^{depth}} pieces of length \code{unit_len}.
}
\details{
Draws a maze in a regular dodecagon. Currently dissects the maze
into a hexagon and a ring of squares and equilateral triangles.

\if{html}{
\figure{simple-dodecagon-1.png}{options: width="100\%" alt="Figure: hex ring dodecagon"}
}
\if{latex}{
\figure{simple-dodecagon-1.png}{options: width=7cm}
}
}
\examples{
\dontrun{
turtle_init(2200,2200,mode='clip')
turtle_hide()
turtle_up()
turtle_do({
  turtle_setpos(25,1100)
  turtle_setangle(0)
	 dodecagon_maze(5,21,draw_boundary=TRUE,boundary_holes=c(1,6))
})
}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
