% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{margin_from_types_byname}
\alias{margin_from_types_byname}
\title{Translate row and column types to integer margins}
\usage{
margin_from_types_byname(a, types)
}
\arguments{
\item{a}{A matrix or list of matrices.}

\item{types}{A character vector or list of character vectors
representing row or column types whose
corresponding integer margins in \code{a} are to be determined.}
}
\value{
A vector of integers or list of vectors of integers
corresponding to the margins on which \code{types} exist.
}
\description{
Converts row and column types to integer margins,
based on \code{a} and \code{types}.
If \code{types} is not a character vector, \code{types} is returned unmodified.
If \code{types} is a character vector, an integer vector is returned
corresponding to the margins on which \code{types} are found.
If \code{types} are not found in the row or column types of \code{a},
\code{NA_integer_} is returned.
}
\examples{
# Works for single matrices
m <- matrix(1) \%>\%
  setrowtype("Product") \%>\% setcoltype("Industry")
margin_from_types_byname(m, "Product")
margin_from_types_byname(m, "Industry")
margin_from_types_byname(m, c("Product", "Industry"))
margin_from_types_byname(m, c("Industry", "Product"))
# Works for lists of matrices
margin_from_types_byname(list(m, m), types = "Product")
margin_from_types_byname(list(m, m), types = "Industry")
margin_from_types_byname(list(m, m), types = c("Product", "Product"))
margin_from_types_byname(list(m, m), types = c("Industry", "Industry"))
margin_from_types_byname(list(m, m), types = c("Product", "Industry"))
margin_from_types_byname(list(m, m), types = list("Product", "Industry"))
margin_from_types_byname(list(m, m), types = list(c("Product", "Industry")))
margin_from_types_byname(list(m, m), types = list(c("Product", "Industry"), 
                                                  c("Product", "Industry")))
# Works in a data frame
m2 <- matrix(2) \%>\%
  setrowtype("Industry") \%>\% setcoltype("Product")
df <- tibble::tibble(m = list(m, m2), types = list("Product", c("Product", "Industry")))
res <- df \%>\%
  dplyr::mutate(
    margin = margin_from_types_byname(m, types)
 )
res$margin
}
