% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramEstimator.R
\name{parameterEstim}
\alias{parameterEstim}
\alias{parameterEstim.separate}
\title{Parameter estimation of full model}
\usage{
parameterEstim.separate(S, model, W, ..., parametersInner = estimator.ols,
  parametersReflective = estimator.ols, parametersFormative = estimator.ols,
  disattenuate = FALSE,
  reliabilities = reliabilityEstim.weightLoadingProduct)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{...}{All other arguments are passed through to \code{parametersInner},
\code{parametersReflective}, and\code{parametersFormative}}

\item{parametersInner}{A function used to estimate the \code{inner} model matrix. The default is
\code{\link{estimator.ols}}}

\item{parametersReflective}{A function used to estimate the \code{reflective} model matrix. The
default is \code{\link{estimator.ols}}}

\item{parametersFormative}{A function used to estimate the \code{formative} model matrix. The
default is \code{\link{estimator.ols}}}

\item{disattenuate}{If \code{TRUE}, \code{C} is
disattenuated before applying \code{parametersInner}.}

\item{reliabilities}{A function for calculating reliability estimates based on the 
data covariance matrix \code{S}, factor loading matrix \code{loadings}, and a weight matrix \code{W}.
Returns a vector of reliability estimates. The default is
\code{\link{reliabilityEstim.weightLoadingProduct}}}
}
\value{
A named vector of parameter estimates.

\code{parameterEstim.separate} returns the following as attributes:

\item{C}{the composite correlation matrix (after disattenuation, if requested).}
\item{IC}{the indicator-composite covariance matrix (after disattenuation, if requested).}
\item{inner}{the \code{inner} model matrix with estimated parameters.}
\item{reflective}{the \code{reflective} model matrix with estimated parameters.}
\item{formative}{the \code{formative} model matrix with estimated parameters.}
\item{Q}{the reliability estimates used in dissattenuation.}

Additionally, all attributes returned by functions called by parameterEstim.separate are returned.
This can include:
\item{c}{the PLSc loading estimate correction factors.}
}
\description{
\code{paramsEstimator} functions estimates the statistical model described by \code{model}
}
\details{
Model can be specified in the lavaan format or the native matrixpls format.
The native model format is a list of three binary matrices, \code{inner}, \code{reflective},
and \code{formative} specifying the free parameters of a model: \code{inner} (\code{l x l}) specifies the 
regressions between composites, \code{reflective} (\code{k x l}) specifies the regressions of observed
data on composites, and \code{formative} (\code{l x k}) specifies the regressions of composites on the
observed data. Here \code{k} is the number of observed variables and \code{l} is the number of composites.

If the model is specified in lavaan format, the native
format model is derived from this model by assigning all regressions between latent
variables to \code{inner}, all factor loadings to \code{reflective}, and all regressions
of latent variables on observed variables to \code{formative}. Regressions between
observed variables and all free covariances are ignored. All parameters that are
specified in the model will be treated as free parameters.

The original papers about Partial Least Squares, as well as many of the current PLS
implementations, impose restrictions on the matrices \code{inner},
\code{reflective}, and \code{formative}: \code{inner} must be a lower triangular matrix,
\code{reflective} must have exactly one non-zero value on each row and must have at least
one non-zero value on each column, and \code{formative} must only contain zeros.
Some PLS implementations allow \code{formative} to contain non-zero values, but impose a
restriction that the sum of \code{reflective} and \code{t(formative)} must satisfy
the original restrictions of \code{reflective}. The only restrictions that matrixpls
imposes on \code{inner}, \code{reflective}, and \code{formative} is that these must be
binary matrices and that the diagonal of \code{inner} must be zeros.

Model estimation proceeds as follows. The weights \code{W} and the
data covariance matrix \code{S} are used to calculate the composite covariance matrix \code{C}
and the indicator-composite covariance matrix \code{IC}. These are matrices are used to
separately estimate each of teh three model matrices \code{inner}, \code{reflective}, and
\code{formative}. This approach of estimating the parameter matrices separately is the
standard way of estimation in the PLS literature.
 
The default estimation approach is to estimate all parameters with a series of OLS 
regressions using \code{\link{estimator.ols}}.
}
\section{Functions}{
\itemize{
\item \code{parameterEstim.separate}: Estimates the model parameters in \code{inner}, \code{reflective}, and
\code{formative} separately.
}}
\references{
Rosseel, Y. (2012). lavaan: An R Package for Structural Equation Modeling. \emph{Journal of Statistical Software}, 48(2), 1–36. Retrieved from http://www.jstatsoft.org/v48/i02
}

