% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.ph.R
\name{fit,ph-method}
\alias{fit,ph-method}
\title{Fit method for ph class}
\usage{
\S4method{fit}{ph}(
  x,
  y,
  weight = numeric(0),
  rcen = numeric(0),
  rcenweight = numeric(0),
  stepsEM = 1000,
  methods = c("RK", "RK"),
  rkstep = NA,
  uni_epsilon = NA,
  maxit = 100,
  reltol = 1e-08,
  every = 100,
  r = 1
)
}
\arguments{
\item{x}{An object of class \linkS4class{ph}.}

\item{y}{Vector or data.}

\item{weight}{Vector of weights.}

\item{rcen}{Vector of right-censored observations.}

\item{rcenweight}{Vector of weights for right-censored observations.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{methods}{Methods to use for matrix exponential calculation: RM, UNI or PADE.}

\item{rkstep}{Runge-Kutta step size (optional).}

\item{uni_epsilon}{Epsilon parameter for uniformization method.}

\item{maxit}{Maximum number of iterations when optimizing g function.}

\item{reltol}{Relative tolerance when optimizing g function.}

\item{every}{Number of iterations between likelihood display updates.}

\item{r}{Sub-sampling proportion for stochastic EM, defaults to 1.}
}
\value{
An object of class \linkS4class{ph}.
}
\description{
Fit method for ph class
}
\examples{
obj <- iph(ph(structure = "general", dimension = 2), gfun = "weibull", gfun_pars = 2)
data <- sim(obj, n = 100)
fit(obj, data, stepsEM = 100, every = 20)
}
