% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matlab2r.R
\name{matlab2r}
\alias{matlab2r}
\title{Convert Matlab function to R}
\usage{
matlab2r(
  filename,
  output = "diff",
  improve_formatting = TRUE,
  change_assignment = TRUE,
  append = FALSE,
  restyle = !improve_formatting
)
}
\arguments{
\item{filename}{name of the file}

\item{output}{can be "asis", "clean", "save" or "diff"}

\item{improve_formatting}{if \code{TRUE} (default), makes minor changes
to conform to best-practice formatting conventions}

\item{change_assignment}{if \code{TRUE} (default), uses \verb{<-} as the assignment operator}

\item{append}{if \code{FALSE} (default), overwrites file; otherwise, append
output to input}

\item{restyle}{if \code{TRUE}, will restyle the output with styler
(only for \code{output = "save"})}
}
\value{
text converted to R, printed to screen or replacing input file
}
\description{
Performs basic syntax conversion from a Matlab function file to R
}
\note{
This function is intended to expedite the process of converting a
Matlab function to R by making common replacements. It does not have the
immediate goal of outputting a ready-to-use function. In other words,
after using this function you should go back to it and make minor changes.

It is also advised to do a dry-run with \code{output = "clean"} and only switching
to \code{output = "save"} when you are confident that no important code will be
lost (for shorter functions, a careful visual inspection should suffice).
}
\examples{
matlab_script <- system.file("extdata", "matlabDemo.m", package = "matlab2r")
matlab2r(matlab_script)
matlab2r(matlab_script, output = "clean")
}
\author{
Waldir Leoncio
}
