% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathml.R
\name{subsupscript}
\alias{subsupscript}
\title{Subsupscript. This is a wrapper for the identity function, but decorates the
result with a sub- and a superscript.}
\usage{
subsupscript(fun = quote(sum(x[i])), sub = quote((i = 1)), sup = quote(N))
}
\arguments{
\item{fun}{an R call or symbol, e.g. \code{sum(x[i])}. This is the return value.}

\item{sub}{an R symbol, e.g., \code{i=1}}

\item{sup}{an R symbol, e.g., \code{N}}
}
\value{
The function over is a wrapper for the identity function, returning \emph{fun}
}
\description{
Subsupscript. This is a wrapper for the identity function, but decorates the
result with a sub- and a superscript.
}
\examples{
N <- 10
i <- 1:N
x <- rnorm(N)
mathjax(call("subsupscript", fun=sum(x[i]), sub=quote(`=`(i, 1L)), sup=quote(N)))

}
\seealso{
\code{\link[=identity]{identity()}}
}
