/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.common.util.iterators.BooleanDomainIterator;
import choco.cp.solver.variables.delta.BooleanDeltaDomain;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.structure.StoredIndexedBipartiteSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import java.util.Random;

public final class BooleanDomain
extends AbstractIntDomain {
    private static final Random random = new Random(System.currentTimeMillis());
    private final int offset;
    private int value;
    private final StoredIndexedBipartiteSet notInstanciated;
    protected BooleanDomainIterator _iterator = null;

    public BooleanDomain(IntDomainVarImpl v, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        this.notInstanciated = (StoredIndexedBipartiteSet)environment.getSharedBipartiteSetForBooleanVars();
        this.offset = environment.getNextOffset();
        this.value = 0;
        this.deltaDom = new BooleanDeltaDomain();
    }

    public final int getValueIfInst() {
        return this.value;
    }

    public final boolean isInstantiated() {
        return !this.notInstanciated.contain(this.offset);
    }

    @Override
    public final int getInf() {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.value;
        }
        return 0;
    }

    @Override
    public final int getSup() {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.value;
        }
        return 1;
    }

    @Override
    public int updateInf(int x) {
        throw new SolverException("Unexpected call of updateInf");
    }

    @Override
    public int updateSup(int x) {
        throw new SolverException("Unexpected call of updateSup");
    }

    @Override
    public final boolean contains(int x) {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.value == x;
        }
        return x == 0 || x == 1;
    }

    @Override
    public boolean remove(int x) {
        throw new SolverException("Unexpected call of remove");
    }

    @Override
    public final void restrict(int x) {
        this.notInstanciated.remove(this.offset);
        this.deltaDom.remove(1 - x);
        this.value = x;
    }

    @Override
    public final int getSize() {
        return this.notInstanciated.contain(this.offset) ? 2 : 1;
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new BooleanDomainIterator();
        } else if (!this._iterator.reusable()) {
            this._iterator = new BooleanDomainIterator();
        }
        this._iterator.init(this);
        return this._iterator;
    }

    @Override
    public final int getNextValue(int x) {
        if (!this.notInstanciated.contain(this.offset)) {
            int val = this.value;
            return val > x ? val : Integer.MAX_VALUE;
        }
        if (x < 0) {
            return 0;
        }
        if (x == 0) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final int getPrevValue(int x) {
        if (x > this.getSup()) {
            return this.getSup();
        }
        if (x > this.getInf()) {
            return this.getInf();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public final boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public final boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public final int getRandomValue() {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.value;
        }
        return random.nextInt(2);
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public String toString() {
        return "[" + this.getInf() + ',' + this.getSup() + ']';
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public boolean updateSup(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._updateSup(x, cause)) {
            this.propagationEngine.postInstInt(this.variable, cause, forceAwake);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateInf(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._updateInf(x, cause)) {
            this.propagationEngine.postInstInt(this.variable, cause, forceAwake);
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeVal(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._removeVal(x, cause)) {
            this.propagationEngine.postInstInt(this.variable, cause, forceAwake);
            return true;
        }
        return false;
    }

    @Override
    public final boolean instantiate(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._instantiate(x, cause)) {
            this.propagationEngine.postInstInt(this.variable, cause, forceAwake);
            return true;
        }
        return false;
    }

    private void failOnIndex(SConstraint cause) throws ContradictionException {
        this.propagationEngine.raiseContradiction(cause);
    }

    @Override
    protected final boolean _instantiate(int x, SConstraint cause) throws ContradictionException {
        if (!this.notInstanciated.contain(this.offset)) {
            if (this.value != x) {
                this.failOnIndex(cause);
            }
            return false;
        }
        if (x == 0 || x == 1) {
            this.restrict(x);
            return true;
        }
        this.failOnIndex(cause);
        return false;
    }

    @Override
    protected final boolean _updateInf(int x, SConstraint cause) throws ContradictionException {
        if (this.isInstantiated()) {
            if (this.value < x) {
                this.failOnIndex(cause);
            }
            return false;
        }
        if (x > 1) {
            this.failOnIndex(cause);
        } else if (x == 1) {
            this.restrict(1);
            return true;
        }
        return false;
    }

    @Override
    protected final boolean _updateSup(int x, SConstraint cause) throws ContradictionException {
        if (this.isInstantiated()) {
            if (this.value > x) {
                this.failOnIndex(cause);
            }
            return false;
        }
        if (x < 0) {
            this.failOnIndex(cause);
        } else if (x == 0) {
            this.restrict(0);
            return true;
        }
        return false;
    }

    @Override
    protected final boolean _removeVal(int x, SConstraint cause) throws ContradictionException {
        if (this.isInstantiated()) {
            if (this.value == x) {
                this.failOnIndex(cause);
            }
            return false;
        }
        if (x == 0) {
            this.restrict(1);
            return true;
        }
        if (x == 1) {
            this.restrict(0);
            return true;
        }
        return false;
    }

    public final int getOffset() {
        return this.offset;
    }
}

