/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews;

import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.solver.Solver;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Logger;

public class PrecsGraphView {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected boolean affiche = false;
    protected Solver solver;
    protected List<StoredBitSetGraph.Maintain> precsParams;
    protected int nbNodes;
    protected StoredBitSetGraph precs;
    protected IStateBitSet[] precsGraph;

    public PrecsGraphView(Solver solver, Node[] nodes) {
        this.solver = solver;
        this.nbNodes = nodes.length;
        this.precsParams = new ArrayList<StoredBitSetGraph.Maintain>();
        this.precsParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_CLOSURE);
        this.precsParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_REDUCTION);
        this.precsParams.add(StoredBitSetGraph.Maintain.CONNECTED_COMP);
        this.precsGraph = new IStateBitSet[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            this.precsGraph[i] = nodes[i].getMandatorySuccessors();
        }
        this.precs = new StoredBitSetGraph(solver, this.precsGraph, this.precsParams, false);
    }

    public boolean addPrec(int u, int v) {
        if (this.affiche) {
            ChocoLogging.flushLogs();
            LOGGER.info("============= Add Incr\u00ef\u00bf\u00bdmental : (" + u + "," + v + ") ================");
            this.precs.showGraph("precs");
            LOGGER.info("---------------");
            this.precs.showAllDesc("tcPrecs");
            LOGGER.info("**********************");
        }
        boolean res = false;
        if (u != v) {
            if (!this.precs.getDescendants(u).get(v)) {
                if (this.affiche) {
                    LOGGER.info("\t\t(" + u + "," + v + ") est ajoute dans Gp!");
                }
                this.precs.addArc(u, v);
                this.precsGraph = this.precs.getTrGraph();
                res = true;
            } else {
                if (this.affiche) {
                    LOGGER.info("\t\t(" + u + "," + v + ") a deja ete ajoute dans Gp");
                }
                res = false;
            }
        }
        if (this.affiche) {
            this.precs.showGraph("precs");
            LOGGER.info("---------------");
            this.precs.showAllDesc("tcPrecs");
            LOGGER.info("============= END Add Incr\u00ef\u00bf\u00bdmental ================");
        }
        return res;
    }

    public StoredBitSetGraph getPrecs() {
        return this.precs;
    }

    public IStateBitSet getSuccessors(int i) {
        return this.precs.getSuccessors(i);
    }

    public IStateBitSet getPredecessors(int i) {
        return this.precs.getPredecessors(i);
    }

    public BitSet getDescendants(int i) {
        return this.hardCopy(this.precs.getDescendants(i));
    }

    public BitSet getAncestors(int i) {
        return this.hardCopy(this.precs.getAncestors(i));
    }

    public IStateBitSet getSinkNodes() {
        return this.precs.getSinkNodes();
    }

    public IStateBitSet getSrcNodes() {
        return this.precs.getSrcNodes();
    }

    public IStateBitSet[] getVertFromNumCC() {
        return this.precs.getVertFromNumCC();
    }

    public IStateBitSet[] getNumFromVertCC() {
        return this.precs.getNumFromVertCC();
    }

    public String showDesc(int i) {
        return this.precs.showDesc(i, "descPrecs");
    }

    public void showPrecGraph() {
        this.precs.showGraph("precs");
    }

    public void showAllDesc() {
        this.precs.showAllDesc("descPrecs");
    }

    private BitSet hardCopy(IStateBitSet b) {
        BitSet bs = new BitSet(this.nbNodes);
        int i = b.nextSetBit(0);
        while (i >= 0) {
            bs.set(i, true);
            i = b.nextSetBit(i + 1);
        }
        return bs;
    }
}

