/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import choco.Choco;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import choco.kernel.solver.variables.set.SetVar;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class VariableUtils {
    private VariableUtils() {
    }

    public static Var[] getVar(Solver solver, Variable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            Var[] vars = new Var[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar(variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static IntDomainVar[] getVar(Solver solver, IntegerVariable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            IntDomainVar[] vars = new IntDomainVar[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar(variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static SetVar[] getVar(Solver solver, SetVariable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            SetVar[] vars = new SetVar[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar(variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static TaskVar[] getVar(Solver solver, TaskVariable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            TaskVar[] vars = new TaskVar[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar(variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static IntDomainVar[] getIntVar(Solver solver, Variable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            IntDomainVar[] vars = new IntDomainVar[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar((IntegerVariable)variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static SetVar[] getSetVar(Solver solver, Variable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            SetVar[] vars = new SetVar[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar((SetVariable)variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static TaskVar[] getTaskVar(Solver solver, Variable[] variables, int begin, int end) {
        if (end > begin && begin >= 0 && end <= variables.length) {
            TaskVar[] vars = new TaskVar[end - begin];
            for (int i = begin; i < end; ++i) {
                vars[i - begin] = solver.getVar((TaskVariable)variables[i]);
            }
            return vars;
        }
        return null;
    }

    public static boolean checkInteger(VariableType v) {
        return v == VariableType.INTEGER || v == VariableType.CONSTANT_INTEGER;
    }

    public static boolean checkSet(VariableType v) {
        return v == VariableType.SET || v == VariableType.CONSTANT_SET;
    }

    public static boolean checkReal(VariableType v) {
        return v == VariableType.REAL || v == VariableType.CONSTANT_DOUBLE || v == VariableType.REAL_EXPRESSION;
    }

    public static int checkType(VariableType v1, VariableType v2) {
        int t1 = 0;
        int t2 = 0;
        if (VariableUtils.checkInteger(v1)) {
            t1 = 1;
        } else if (VariableUtils.checkSet(v1)) {
            t1 = 2;
        } else if (VariableUtils.checkReal(v1)) {
            t1 = 3;
        }
        if (VariableUtils.checkInteger(v2)) {
            t2 = 1;
        } else if (VariableUtils.checkSet(v2)) {
            t2 = 2;
        } else if (VariableUtils.checkReal(v2)) {
            t2 = 3;
        }
        return 10 * t1 + t2;
    }

    public static void quicksort(int[] a, IntDomainVar[] vs, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = VariableUtils.partition(a, vs, left, right);
        VariableUtils.quicksort(a, vs, left, i - 1);
        VariableUtils.quicksort(a, vs, i + 1, right);
    }

    public static int partition(int[] a, IntDomainVar[] vs, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            VariableUtils.exch(a, vs, i, j);
        }
        VariableUtils.exch(a, vs, i, right);
        return i;
    }

    public static void exch(int[] a, IntDomainVar[] vs, int i, int j) {
        int swap = a[i];
        IntDomainVar vswap = vs[i];
        a[i] = a[j];
        vs[i] = vs[j];
        a[j] = swap;
        vs[j] = vswap;
    }

    public static void reverse(int[] tab, IntDomainVar[] vs) {
        int i;
        int[] revtab = new int[tab.length];
        IntDomainVar[] revvs = new IntDomainVar[vs.length];
        for (i = 0; i < revtab.length; ++i) {
            revtab[i] = tab[revtab.length - 1 - i];
            revvs[i] = vs[revtab.length - 1 - i];
        }
        for (i = 0; i < revtab.length; ++i) {
            tab[i] = revtab[i];
            vs[i] = revvs[i];
        }
    }

    public static IntegerVariable createDirVariable(TaskVariable t1, TaskVariable t2, String ... boolOptions) {
        return Choco.makeBooleanVar("dir-" + t1.getName() + '-' + t2.getName(), boolOptions);
    }

    public static IntegerVariable[] getStartVariables(TaskVariable ... tasks) {
        IntegerVariable[] vars = new IntegerVariable[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            vars[i] = tasks[i].start();
        }
        return vars;
    }

    public static IntegerVariable[] getDurationVariables(TaskVariable ... tasks) {
        IntegerVariable[] vars = new IntegerVariable[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            vars[i] = tasks[i].duration();
        }
        return vars;
    }

    public static IntegerVariable[] getEndVariables(TaskVariable ... tasks) {
        IntegerVariable[] vars = new IntegerVariable[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            vars[i] = tasks[i].end();
        }
        return vars;
    }

    public static IntegerVariable[] getStartVariables(List<TaskVariable> tasks) {
        IntegerVariable[] vars = new IntegerVariable[tasks.size()];
        ListIterator<TaskVariable> iter = tasks.listIterator();
        while (iter.hasNext()) {
            vars[iter.nextIndex()] = iter.next().start();
        }
        return vars;
    }

    public static IntegerVariable[] getDurationVariables(List<TaskVariable> tasks) {
        IntegerVariable[] vars = new IntegerVariable[tasks.size()];
        ListIterator<TaskVariable> iter = tasks.listIterator();
        while (iter.hasNext()) {
            vars[iter.nextIndex()] = iter.next().duration();
        }
        return vars;
    }

    public static IntegerVariable[] getEndVariables(List<TaskVariable> tasks) {
        IntegerVariable[] vars = new IntegerVariable[tasks.size()];
        ListIterator<TaskVariable> iter = tasks.listIterator();
        while (iter.hasNext()) {
            vars[iter.nextIndex()] = iter.next().end();
        }
        return vars;
    }

    public static IntDomainVar createDirVar(Solver solver, TaskVar t1, TaskVar t2) {
        return solver.createBooleanVar(StringUtils.dirRandomName(t1.getName(), t2.getName()));
    }

    public static IntDomainVar[] getStartVars(TaskVar ... tasks) {
        IntDomainVar[] vars = new IntDomainVar[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            vars[i] = tasks[i].start();
        }
        return vars;
    }

    public static IntDomainVar[] getDurationVars(TaskVar ... tasks) {
        IntDomainVar[] vars = new IntDomainVar[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            vars[i] = tasks[i].duration();
        }
        return vars;
    }

    public static IntDomainVar[] getEndVars(TaskVar ... tasks) {
        IntDomainVar[] vars = new IntDomainVar[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            vars[i] = tasks[i].end();
        }
        return vars;
    }

    public static IntDomainVar[] getStartVars(List<TaskVar> tasks) {
        IntDomainVar[] vars = new IntDomainVar[tasks.size()];
        ListIterator<TaskVar> iter = tasks.listIterator();
        while (iter.hasNext()) {
            vars[iter.nextIndex()] = iter.next().start();
        }
        return vars;
    }

    public static IntDomainVar[] getDurationVars(List<TaskVar> tasks) {
        IntDomainVar[] vars = new IntDomainVar[tasks.size()];
        ListIterator<TaskVar> iter = tasks.listIterator();
        while (iter.hasNext()) {
            vars[iter.nextIndex()] = iter.next().duration();
        }
        return vars;
    }

    public static IntDomainVar[] getEndVars(List<TaskVar> tasks) {
        IntDomainVar[] vars = new IntDomainVar[tasks.size()];
        ListIterator<TaskVar> iter = tasks.listIterator();
        while (iter.hasNext()) {
            vars[iter.nextIndex()] = iter.next().end();
        }
        return vars;
    }

    public static IntDomainVar[] getIntVars(Solver solver) {
        int n = solver.getNbIntVars();
        IntDomainVar[] vars = new IntDomainVar[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = solver.getIntVarQuick(i);
        }
        return vars;
    }

    public static SetVar[] getSetVars(Solver solver) {
        int n = solver.getNbSetVars();
        SetVar[] vars = new SetVar[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = solver.getSetVarQuick(i);
        }
        return vars;
    }

    public static RealVar[] getRealVars(Solver solver) {
        int n = solver.getNbRealVars();
        RealVar[] vars = new RealVar[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = solver.getRealVar(i);
        }
        return vars;
    }

    public static TaskVar[] getTaskVars(Solver solver) {
        int n = solver.getNbTaskVars();
        TaskVar[] vars = new TaskVar[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = solver.getTaskVarQuick(i);
        }
        return vars;
    }

    public static <E> E[] getDecisionList(List<E> decisions, List<E> all, Class<E> clazz) {
        if (decisions.isEmpty()) {
            Object[] tmp = (Object[])Array.newInstance(clazz, all.size());
            return all.toArray(tmp);
        }
        Object[] tmp = (Object[])Array.newInstance(clazz, decisions.size());
        return decisions.toArray(tmp);
    }

    public static int[] getConstantValues(IntVar ... vars) {
        int[] cards = new int[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            if (!vars[i].isInstantiated()) {
                throw new SolverException(vars[i].pretty() + " is not an integer constant");
            }
            cards[i] = vars[i].getVal();
        }
        return cards;
    }

    public static IntegerVariable[] getCardinalities(SetVariable ... vars) {
        IntegerVariable[] cards = new IntegerVariable[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            cards[i] = vars[i].getCard();
        }
        return cards;
    }

    public static boolean checkConstant(IntegerVariable v, int value) {
        return v.isConstant() && v.canBeEqualTo(value);
    }

    public static IntDomainVar[] getBoolDecisionVars(Solver solver) {
        int i;
        IntDomainVar[] ivs = solver.getIntDecisionVars();
        for (i = 0; i < ivs.length && ivs[i].hasBooleanDomain(); ++i) {
        }
        if (i < ivs.length) {
            LinkedList<IntDomainVar> bvs = new LinkedList<IntDomainVar>();
            for (IntDomainVar v : ivs) {
                if (!v.hasBooleanDomain()) continue;
                bvs.add(v);
            }
            ivs = bvs.toArray(new IntDomainVar[bvs.size()]);
        }
        return ivs;
    }
}

