/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering;

import choco.cp.solver.constraints.global.tree.filtering.RemovalsAdvisor;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.costStrutures.CostStructure;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.dominatorTrees.DominatorView;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.PrecsGraphView;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class AbstractPropagator {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected Solver solver;
    protected TreeParameters tree;
    protected Node[] nodes;
    protected int[] indices;
    protected StructuresAdvisor struct;
    protected CostStructure costStruct;
    protected RemovalsAdvisor propagateStruct;
    protected boolean affiche;
    protected int nbVertices;
    protected VarGraphView inputGraph;
    protected PrecsGraphView precs;
    protected DominatorView doms;
    protected StoredBitSetGraph incomp;
    protected StoredBitSetGraph condPrecs;

    protected AbstractPropagator(Object[] params) {
        this.solver = (Solver)params[0];
        this.tree = (TreeParameters)params[1];
        this.indices = (int[])params[2];
        this.struct = (StructuresAdvisor)params[3];
        this.costStruct = (CostStructure)params[4];
        this.propagateStruct = (RemovalsAdvisor)params[5];
        this.affiche = (Boolean)params[6];
        this.nodes = this.tree.getNodes();
        this.nbVertices = this.nodes.length;
        this.inputGraph = this.struct.getInputGraph();
        this.precs = this.struct.getPrecs();
        this.doms = this.struct.getDoms();
        this.incomp = this.struct.getIncomp();
        this.condPrecs = this.struct.getCondPrecs();
    }

    public abstract String getTypePropag();

    public boolean applyConstraint() throws ContradictionException, IOException {
        if (!this.feasibility()) {
            if (this.affiche) {
                LOGGER.info("==> Fail() on feasibility() test");
            }
            return false;
        }
        this.filter();
        return true;
    }

    public abstract boolean feasibility() throws ContradictionException;

    public abstract void filter() throws ContradictionException;
}

