% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{cross}
\alias{cross}
\alias{X}
\title{Coordinates of a cross}
\usage{
cross(
  size.x = sqrt(square()$size.x[[1]]^2/2),
  size.y = size.x,
  lwd = 3,
  lty = 1
)

X(size.x = sqrt(square()$size.x[[1]]^2/2), size.y = size.x, lwd = 3, lty = 1)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is sqrt(square()$ size.x[[1]]^2 /2)}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x.}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line}
}
\value{
Return the coordinates for drawing a cross

Return the coordinates for drawing an X
}
\description{
Define the coordinates for drawing a cross
}
\section{Functions}{
\itemize{
\item \code{X()}: Coordinates of an X

Define the coordinates for drawing an X

}}
\examples{
# default coordinates of an horizontal line
cross()
# draw a vertical line with different lty
draw(cross(lty = 2))
# default coordinates of an X
X()
# draw an X with different lty
draw(X(lty = 2))
}
