#' Difference distractor (Method)
#'
#' Generate difference distractor from a matriks
#'
#' @param obj matriks, The matriks for which the distractor is generated
#' @param seed integer, random seed for the generation of the difference distractor
#' @param ... other arguments
#'
#' @return An object of class figure that is the difference distractor of a matrix
#' @export difference
#' @export
#'
#' @examples
#' # create a matrix
#' m1 <- mat_apply(hexagon(), hrules = "lty")
#' # draw the matrix
#' draw(m1)
#' # draw the difference distractor
#' draw(difference(m1))
difference <- function(obj, seed, ...) {
  UseMethod("difference")
}


#' @describeIn difference Difference distractors
#'
#' @param obj matriks, The matriks for which the distractor is generated
#' @param seed seed
#' @param ... other arguments
#'
#' @return An object of class figure that is the difference distractor of a matrix
#' @export difference.matriks
#' @export
#'
#' @examples
#' # create a matrix
#' m1 <- mat_apply(hexagon(), hrules = "lty")
#' # draw the matrix
#' draw(m1)
#' # draw the difference distractor
#' draw(difference(m1))
difference.matriks <- function(obj, seed = 666, ...) {
  set.seed(seed)
  hrules <- gsub(".inv", "", obj$hrule)
  vrules <-  gsub(".inv", "", obj$vrule)

  if (any(hrules[order(hrules)] == vrules[order(vrules)]) == TRUE) {
    start_cell <-  obj$Sq3
  } else {
    start_cell <- obj$Sq1
  }

  # list_star<-dir(paste0(system.file(package = "matRiks"), "/R"))
  # list_star<-list_star[grep("figure",list_star)]
  # list_star<-paste0(paste0(system.file(package = "matRiks"), "/R/"),list_star)
  # list_figures <- multi_list(list_star)
  list_figures <- data.frame(name  = c(
    'biscuit',
    'cross_dice',
    'dice',
    'dot',
    'ninja',
    's_biscuit',
    's_ninja',
    's_star',
    'star',
    'pacman',
    'pizza_2',
    'pizza_2_inv',
    'pizza_4',
    's_pizza_2',
    's_pizza_2_inv',
    's_pizza_4',
    'semi_circle',
    'semi_circle_inv',
    'semi_circle_inv_inv',
    'slice',
    'circle',
    'ellipse',
    'hexagon',
    'luck',
    'pentagon',
    'rectangle',
    'square',
    'triangle',
    'horizontal_eight',
    's_horizontal_eight',
    's_vertical_eight',
    'vertical_eight',
    'down_petal',
    'left_petal',
    'lily',
    'miley',
    'right_petal',
    's_lily',
    's_miley',
    'up_petal',
    'axe',
    'hor_bow_tie',
    'malta',
    'maxi',
    'phantom',
    's_axe',
    's_hor_bow_tie',
    's_malta',
    's_maxi',
    's_vert_bow_tie',
    'vert_bow_tie' ),
    num_shapes  = c(
      2 ,
      4 ,
      4 ,
      1 ,
      2 ,
      2 ,
      2 ,
      4 ,
      4 ,
      1 ,
      2 ,
      2 ,
      4 ,
      2 ,
      2 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      1 ,
      4 ,
      2 ,
      2 ,
      4 ,
      2 ,
      2 ,
      2 ,
      4 ,
      2 ,
      1 ,
      1 ,
      2 ,
      2 ,
      2 ,
      4 ,
      4 ,
      1 ,
      2 ,
      2 ,
      2 ,
      4 ,
      2 ,
      2 ),
    fill  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ),
    rotate  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    d.int  = c(
      TRUE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ),
    d.ext  = c(
      FALSE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    no.d  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    vert  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ),
    hor  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    inv  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    up  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    down  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    left  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ),
    right  = c(
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      TRUE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ,
      FALSE ))
  list_figures <- list_figures[!list_figures$name %in% unlist(obj$Sq1$shape), ]

  if (sum(grepl("d.int", unlist(start_cell))) == 0) {
    over_figure <- sample(list_figures[list_figures$d.int == TRUE, "name"])
    over_figure <- get(over_figure[1])
    if (any(unlist(over_figure()$tag) == "black.figure") == TRUE) {
      over_figure <- size(over_figure(), 3)
      dist_difference <- cof(start_cell,
                             over_figure)
    } else {
      dist_difference <- cof(start_cell,
                             over_figure())
    }
  } else {
    over_figure <- sample(list_figures[list_figures$d.ext == TRUE, "name"])
    over_figure <- get(over_figure[1])
    dist_difference <- cof(start_cell,
                           over_figure())
  }


  class(dist_difference) <- "figure"
  return(dist_difference)


}
