% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_marquee.R
\name{guide_marquee}
\alias{guide_marquee}
\title{Marquee subtitle guide}
\usage{
guide_marquee(
  title = ggplot2::waiver(),
  style = marquee::style(background = NA),
  detect = FALSE,
  theme = NULL,
  position = "top",
  override.aes = list(),
  order = 1
)
}
\arguments{
\item{title}{A single character string indicating the text to display. If
\code{NULL} the title is not shown. If \code{\link[ggplot2:waiver]{waiver()}}
(default), the name of the scale or the name specified in
\code{\link[ggplot2:labs]{labs()}} is used for the tyle.}

\item{style}{Either a \link[=style_set]{style_set} to override style sets
inherited from the theme, or a \link[=style]{style} for styling the labels
specifically. For \code{colour} or \code{fill} scales, the \code{color}, \code{background} and
\code{border} style properties are overridden when set as \code{NULL}, see examples.}

\item{detect}{Either \code{FALSE} to typeset entirely through syntax or \code{TRUE} to
automatically detect labels and apply.}

\item{theme}{A \code{\link[ggplot2:theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides, and is combined with, the plot's theme.}

\item{position}{A character string indicating where the legend should be
placed relative to the plot panels.}

\item{override.aes}{A list specifying aesthetic parameters of the legend
keys. See details and examples in
\code{\link[ggplot2:guide_legend]{?guide_legend}}.}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}
}
\value{
A GuideMarquee object that can be passed to the
\code{\link[ggplot2:guides]{guides()}} function or used as the \code{guide} argument in
a scale.
}
\description{
This legend appears similar to a subtitle and uses marquee syntax to typeset
the text and interpolate legend glyphs.
}
\section{Text formatting}{
In addition to standard \link[=marquee_parse]{marquee syntax}, there is
additional syntax to make building a guide easier. In the text below, \code{n}
marks the \code{n}-th break in the scale, \code{label} represents any of the scale's
labels and \code{foo} represents arbitrary text.
\itemize{
\item \verb{<<n>>} or \verb{<<label>>} can be used to insert key glyphs into the text.
\item \verb{![](n)} or \verb{![](label)} can also be used to insert key glyphs into the
text.
\item \verb{\{.n foo\}} or \verb{\{.label foo\}} applies the \code{style} argument to \code{foo},
including recoloring when the guide represents a \code{colour} or \code{fill} scale.
\item \code{!!n} or \code{!!label} translates to \verb{\{.label label\}} to insert the label
verbatim with the application of the \code{style} argument.
}
}

\examples{
\dontshow{if (rlang::is_installed("ggplot2", version = "3.5.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
# A standard plot
base <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Using key glyphs
base + aes(shape = drv) +
  scale_shape_discrete(
    # Same as using <<1>>, <<2>> and <<3>>,
    # or ![](1), ![](2) and ![](3)
    # or ![](4), ![](f) and ![](r)
    name = "Cars with four wheel <<4>>, forward <<f>> or reverse <<r>> drive.",
    guide = "marquee"
  )

# Recolouring text
base <- base +
  aes(colour = drv) +
  labs(
    colour = "Cars with {.4 four wheel}, {.f forward} or {.r reverse} drive."
  )
base + guides(colour = "marquee")

# Adjust display of labels
st <- style(weight = "bold", italic = TRUE, background = NA)
base + guides(colour = guide_marquee(style = st))

# Using background instead of text colour by setting it to NULL
st <- style(color = "black", background = NULL)
base + guides(colour = guide_marquee(style = st))

# Customising style of each label through style sets
# Note: tag names must be universal per `vctrs::vec_as_names` and
# prefixed with `lab_`.
st <- classic_style()
st <- modify_style(st, tag = "lab_f", background = NULL, color = "black")
st <- modify_style(st, tag = "lab_r", border_size = trbl(1),
                   color = "black", background = NA)
base + guides(colour = guide_marquee(style = st))

# Alternatively:
base + guides(colour = "marquee") +
  theme(plot.subtitle = element_marquee(style = st))

# Splicing in labels by number (!!2) or label (!!subcompact)
base + aes(colour = class) +
  labs(colour = "Cars including !!2 and !!subcompact vehicles") +
  guides(colour = "marquee")

# Using automatic detection
base + aes(colour = class) +
  labs(colour = "Cars including suv and minivan vehicles") +
  guides(colour = guide_marquee(detect = TRUE))
\dontshow{\}) # examplesIf}
}
