% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_probabilistic.R
\name{meanFirstPassageTime}
\alias{meanFirstPassageTime}
\title{Mean First Passage Time for markovchain}
\usage{
meanFirstPassageTime(markovchain,destination_set)
}
\arguments{
\item{markovchain}{the markovchain-class object}

\item{destination_set}{the set of destination states or NULL (all states)}
}
\value{
a vector (if destination_set given) or a matrix (otherwise) of mean passage times
}
\description{
Given a markovchain object,
this function calculates the expected steps to go from state i to j
}
\details{
if destination_set is one or more states, the mean first
passage time from each remaining state to the given set is computed.
If NULL, the full MFPT matrix is computed (with a different algorithm).
}
\examples{
Pmat <- matrix( c(6,3,1,  2,3,5, 4,1,5)/10, ncol=3, byrow=TRUE)
P <- new("markovchain", states=c("s","c","r"), transitionMatrix=Pmat)
meanFirstPassageTime(P,"r")
meanFirstPassageTime(P)

# Grinstead and Snell's "Oz weather" worked out example
Poz <- new("markovchain", states=c("s","c","r"), 
           transitionMatrix=matrix(c(2,1,1, 2,0,2, 1,1,2)/4, byrow=TRUE, ncol=3)) 
meanFirstPassageTime(Poz)  
}
\references{
C. M. Grinstead and J. L. Snell. Introduction to Probability. American Mathematical Soc., 2012.
}
\author{
Toni Giorgino
}
